/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String PROVIDER_ID = "oidc-user-attribute-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Attribute Importer";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        Object value = UserAttributeMapper.getClaimValue(mapperModel, context);
        if (value != null) {
            context.setUserAttribute(attribute, value.toString());
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        Object value = UserAttributeMapper.getClaimValue(mapperModel, context);
        String current = user.getFirstAttribute(attribute);
        if (value != null && !value.equals(current)) {
            user.setSingleAttribute(attribute, value.toString());
        } else if (value == null) {
            user.removeAttribute(attribute);
        }
    }

    public String getHelpText() {
        return "Import declared claim if it exists in ID or access token into the specified user attribute.";
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName("claim");
        property1.setLabel("Claim");
        property1.setHelpText("Name of claim to search for in token.  You can reference nested claims using a '.', i.e. 'address.locality'.");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE);
        property.setLabel("User Attribute Name");
        property.setHelpText("User attribute name to store claim.");
        property.setType("String");
        configProperties.add(property);
    }
}

