/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientTemplateAdapter;
import org.keycloak.models.mongo.keycloak.adapters.GroupAdapter;
import org.keycloak.models.mongo.keycloak.adapters.MigrationModelAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoGroupEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoMigrationModelEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class MongoRealmProvider
implements RealmProvider {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoRealmProvider(KeycloakSession session, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.invocationContext = invocationContext;
    }

    public void close() {
    }

    public MigrationModel getMigrationModel() {
        MongoMigrationModelEntity entity = (MongoMigrationModelEntity)this.getMongoStore().loadEntity(MongoMigrationModelEntity.class, "VERSION", this.invocationContext);
        if (entity == null) {
            entity = new MongoMigrationModelEntity();
            this.getMongoStore().insertEntity((MongoIdentifiableEntity)entity, this.invocationContext);
        }
        return new MigrationModelAdapter(this.session, entity, this.invocationContext);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        MongoRealmEntity newRealm = new MongoRealmEntity();
        newRealm.setId(id);
        newRealm.setName(name);
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)newRealm, this.invocationContext);
        final RealmAdapter model = new RealmAdapter(this.session, newRealm, this.invocationContext);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmCreationEvent(){

            public RealmModel getCreatedRealm() {
                return model;
            }
        });
        return model;
    }

    public RealmModel getRealm(String id) {
        MongoRealmEntity realmEntity = (MongoRealmEntity)this.getMongoStore().loadEntity(MongoRealmEntity.class, id, this.invocationContext);
        return realmEntity != null ? new RealmAdapter(this.session, realmEntity, this.invocationContext) : null;
    }

    public List<RealmModel> getRealms() {
        BasicDBObject query = new BasicDBObject();
        List realms = this.getMongoStore().loadEntities(MongoRealmEntity.class, (DBObject)query, this.invocationContext);
        ArrayList<RealmModel> results = new ArrayList<RealmModel>();
        for (MongoRealmEntity realmEntity : realms) {
            results.add(new RealmAdapter(this.session, realmEntity, this.invocationContext));
        }
        return results;
    }

    public RealmModel getRealmByName(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).get();
        MongoRealmEntity realm = (MongoRealmEntity)this.getMongoStore().loadSingleEntity(MongoRealmEntity.class, query, this.invocationContext);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, realm, this.invocationContext);
    }

    public boolean removeRealm(String id) {
        RealmModel realm = this.getRealm(id);
        if (realm == null) {
            return false;
        }
        this.session.users().preRemove(realm);
        return this.getMongoStore().removeEntity(MongoRealmEntity.class, id, this.invocationContext);
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        MongoRoleEntity role = (MongoRoleEntity)this.getMongoStore().loadEntity(MongoRoleEntity.class, id, this.invocationContext);
        if (role == null) {
            return null;
        }
        if (role.getRealmId() != null && !role.getRealmId().equals(realm.getId())) {
            return null;
        }
        if (role.getClientId() != null && realm.getClientById(role.getClientId()) == null) {
            return null;
        }
        return new RoleAdapter(this.session, realm, role, null, this.invocationContext);
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        MongoGroupEntity group = (MongoGroupEntity)this.getMongoStore().loadEntity(MongoGroupEntity.class, id, this.invocationContext);
        if (group == null) {
            return null;
        }
        if (group.getRealmId() != null && !group.getRealmId().equals(realm.getId())) {
            return null;
        }
        return new GroupAdapter(this.session, realm, group, this.invocationContext);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        MongoClientEntity appData = (MongoClientEntity)this.getMongoStore().loadEntity(MongoClientEntity.class, id, this.invocationContext);
        if (appData == null || !realm.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ClientAdapter(this.session, realm, appData, this.invocationContext);
    }

    public ClientTemplateModel getClientTemplateById(String id, RealmModel realm) {
        MongoClientTemplateEntity appData = (MongoClientTemplateEntity)this.getMongoStore().loadEntity(MongoClientTemplateEntity.class, id, this.invocationContext);
        if (appData == null || !realm.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ClientTemplateAdapter(this.session, realm, appData, this.invocationContext);
    }
}

