/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClientTemplate;

public class ClientTemplateAdapter
implements ClientTemplateModel {
    protected CacheRealmProvider cacheSession;
    protected RealmModel cachedRealm;
    protected RealmCache cache;
    protected ClientTemplateModel updated;
    protected CachedClientTemplate cached;

    public ClientTemplateAdapter(RealmModel cachedRealm, CachedClientTemplate cached, CacheRealmProvider cacheSession, RealmCache cache) {
        this.cachedRealm = cachedRealm;
        this.cache = cache;
        this.cacheSession = cacheSession;
        this.cached = cached;
    }

    private void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerApplicationInvalidation(this.getId());
            this.updated = this.cacheSession.getDelegate().getClientTemplateById(this.getId(), this.cachedRealm);
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public String getId() {
        if (this.updated != null) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public RealmModel getRealm() {
        return this.cachedRealm;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        if (this.updated != null) {
            return this.updated.getProtocolMappers();
        }
        return this.cached.getProtocolMappers();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addProtocolMapper(model);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeProtocolMapper(mapping);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateProtocolMapper(mapping);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        for (ProtocolMapperModel mapping : this.cached.getProtocolMappers()) {
            if (!mapping.getId().equals(id)) continue;
            return mapping;
        }
        return null;
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        for (ProtocolMapperModel mapping : this.cached.getProtocolMappers()) {
            if (!mapping.getProtocol().equals(protocol) || !mapping.getName().equals(name)) continue;
            return mapping;
        }
        return null;
    }

    public String getName() {
        if (this.updated != null) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDescription() {
        if (this.updated != null) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public String getProtocol() {
        if (this.updated != null) {
            return this.updated.getProtocol();
        }
        return this.cached.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getDelegateForUpdate();
        this.updated.setProtocol(protocol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientTemplateModel that = (ClientTemplateModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

