/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.authentication.requiredactions.util.UserUpdateProfileContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.freemarker.BrowserSecurityHeaderSetup;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.FreeMarkerUtil;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.freemarker.beans.AdvancedMessageFormatterMethod;
import org.keycloak.freemarker.beans.LocaleBean;
import org.keycloak.freemarker.beans.MessageBean;
import org.keycloak.freemarker.beans.MessageFormatterMethod;
import org.keycloak.freemarker.beans.MessageType;
import org.keycloak.freemarker.beans.MessagesPerFieldBean;
import org.keycloak.login.LoginFormsPages;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.login.freemarker.AuthenticatorConfiguredMethod;
import org.keycloak.login.freemarker.LoginFormsUtil;
import org.keycloak.login.freemarker.Templates;
import org.keycloak.login.freemarker.model.ClientBean;
import org.keycloak.login.freemarker.model.CodeBean;
import org.keycloak.login.freemarker.model.IdentityProviderBean;
import org.keycloak.login.freemarker.model.LoginBean;
import org.keycloak.login.freemarker.model.OAuthGrantBean;
import org.keycloak.login.freemarker.model.ProfileBean;
import org.keycloak.login.freemarker.model.RealmBean;
import org.keycloak.login.freemarker.model.RegisterBean;
import org.keycloak.login.freemarker.model.RequiredActionUrlFormatterMethod;
import org.keycloak.login.freemarker.model.TotpBean;
import org.keycloak.login.freemarker.model.UrlBean;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.Urls;

public class FreeMarkerLoginFormsProvider
implements LoginFormsProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerLoginFormsProvider.class);
    private String accessCode;
    private Response.Status status;
    private List<RoleModel> realmRolesRequested;
    private MultivaluedMap<String, RoleModel> resourceRolesRequested;
    private List<ProtocolMapperModel> protocolMappersRequested;
    private MultivaluedMap<String, String> queryParams;
    private Map<String, String> httpResponseHeaders = new HashMap<String, String>();
    private String accessRequestMessage;
    private URI actionUri;
    private List<FormMessage> messages = null;
    private MessageType messageType = MessageType.ERROR;
    private MultivaluedMap<String, String> formData;
    private KeycloakSession session;
    private FreeMarkerUtil freeMarker;
    private UserModel user;
    private ClientSessionModel clientSession;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public FreeMarkerLoginFormsProvider(KeycloakSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
        this.attributes.put("scripts", new LinkedList());
    }

    public void addScript(String scriptUrl) {
        List scripts = (List)this.attributes.get("scripts");
        scripts.add(scriptUrl);
    }

    public Response createResponse(UserModel.RequiredAction action) {
        LoginFormsPages page;
        String actionMessage;
        RealmModel realm = this.session.getContext().getRealm();
        UriInfo uriInfo = this.session.getContext().getUri();
        switch (action) {
            case CONFIGURE_TOTP: {
                actionMessage = "configureTotpMessage";
                page = LoginFormsPages.LOGIN_CONFIG_TOTP;
                break;
            }
            case UPDATE_PROFILE: {
                UserUpdateProfileContext userBasedContext = new UserUpdateProfileContext(realm, this.user);
                this.attributes.put("updateProfileCtx", userBasedContext);
                actionMessage = "updateProfileMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PROFILE;
                break;
            }
            case UPDATE_PASSWORD: {
                actionMessage = "updatePasswordMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PASSWORD;
                break;
            }
            case VERIFY_EMAIL: {
                try {
                    UriBuilder builder = Urls.loginActionEmailVerificationBuilder((URI)uriInfo.getBaseUri());
                    builder.queryParam("code", new Object[]{this.accessCode});
                    builder.queryParam("key", new Object[]{this.clientSession.getNote("VERIFY_EMAIL_KEY")});
                    String link = builder.build(new Object[]{realm.getName()}).toString();
                    long expiration = TimeUnit.SECONDS.toMinutes(realm.getAccessCodeLifespanUserAction());
                    ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(realm).setUser(this.user).sendVerifyEmail(link, expiration);
                }
                catch (EmailException e) {
                    logger.error((Object)"Failed to send verification email", (Throwable)e);
                    return this.setError("emailSendErrorMessage", new Object[0]).createErrorPage();
                }
                actionMessage = "verifyEmailMessage";
                page = LoginFormsPages.LOGIN_VERIFY_EMAIL;
                break;
            }
            default: {
                return Response.serverError().build();
            }
        }
        if (this.messages == null) {
            this.setMessage(MessageType.WARNING, actionMessage, new Object[0]);
        }
        return this.createResponse(page);
    }

    private Response createResponse(LoginFormsPages page) {
        Properties messagesBundle;
        Theme theme;
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = this.session.getContext().getClient();
        UriInfo uriInfo = this.session.getContext().getUri();
        MultivaluedMapImpl queryParameterMap = this.queryParams != null ? this.queryParams : new MultivaluedMapImpl();
        String requestURI = uriInfo.getBaseUri().getPath();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)requestURI);
        for (String k : queryParameterMap.keySet()) {
            Object[] objects = ((List)queryParameterMap.get((Object)k)).toArray();
            if (objects.length == 1 && objects[0] == null) continue;
            uriBuilder.replaceQueryParam(k, objects);
        }
        if (this.accessCode != null) {
            uriBuilder.replaceQueryParam("code", new Object[]{this.accessCode});
        }
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        try {
            theme = themeProvider.getTheme(realm.getLoginTheme(), Theme.Type.LOGIN);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        try {
            this.attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        try {
            messagesBundle = theme.getMessages(locale);
            this.attributes.put("msg", new MessageFormatterMethod(locale, messagesBundle));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messagesBundle = new Properties();
        }
        MessagesPerFieldBean messagesPerField = new MessagesPerFieldBean();
        if (this.messages != null) {
            MessageBean wholeMessage = new MessageBean(null, this.messageType);
            for (FormMessage message : this.messages) {
                String formattedMessageText = this.formatMessage(message, messagesBundle, locale);
                if (formattedMessageText == null) continue;
                wholeMessage.appendSummaryLine(formattedMessageText);
                messagesPerField.addMessage(message.getField(), formattedMessageText, this.messageType);
            }
            this.attributes.put("message", wholeMessage);
        } else {
            this.attributes.put("message", null);
        }
        this.attributes.put("messagesPerField", messagesPerField);
        if (page == LoginFormsPages.OAUTH_GRANT) {
            uriBuilder.replaceQuery(null);
        }
        URI baseUri = uriBuilder.build(new Object[0]);
        this.attributes.put("requiredActionUrl", new RequiredActionUrlFormatterMethod(realm, baseUri));
        if (realm != null && this.user != null && this.session != null) {
            this.attributes.put("authenticatorConfigured", new AuthenticatorConfiguredMethod(realm, this.user, this.session));
        }
        if (realm != null) {
            this.attributes.put("realm", new RealmBean(realm));
            List<IdentityProviderModel> identityProviders = realm.getIdentityProviders();
            identityProviders = LoginFormsUtil.filterIdentityProviders(identityProviders, this.session, realm, this.attributes, this.formData);
            this.attributes.put("social", new IdentityProviderBean(realm, identityProviders, baseUri, uriInfo));
            this.attributes.put("url", new UrlBean(realm, theme, baseUri, this.actionUri));
            if (realm.isInternationalizationEnabled()) {
                UriBuilder b;
                switch (page) {
                    case LOGIN: {
                        b = UriBuilder.fromUri((URI)Urls.realmLoginPage((URI)baseUri, (String)realm.getName()));
                        break;
                    }
                    case REGISTER: {
                        b = UriBuilder.fromUri((URI)Urls.realmRegisterPage((URI)baseUri, (String)realm.getName()));
                        break;
                    }
                    default: {
                        b = UriBuilder.fromUri((URI)baseUri).path(uriInfo.getPath());
                    }
                }
                this.attributes.put("locale", new LocaleBean(realm, locale, b, messagesBundle));
            }
        }
        if (client != null) {
            this.attributes.put("client", new ClientBean(client, baseUri));
        }
        this.attributes.put("login", new LoginBean(this.formData));
        switch (page) {
            case LOGIN_CONFIG_TOTP: {
                this.attributes.put("totp", new TotpBean(realm, this.user, baseUri));
                break;
            }
            case LOGIN_UPDATE_PROFILE: {
                UpdateProfileContext userCtx = (UpdateProfileContext)this.attributes.get("updateProfileCtx");
                this.attributes.put("user", new ProfileBean(userCtx, this.formData));
                break;
            }
            case LOGIN_IDP_LINK_CONFIRM: 
            case LOGIN_IDP_LINK_EMAIL: {
                BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
                String idpAlias = brokerContext.getIdpConfig().getAlias();
                idpAlias = ObjectUtil.capitalize((String)idpAlias);
                this.attributes.put("brokerContext", brokerContext);
                this.attributes.put("idpAlias", idpAlias);
                break;
            }
            case REGISTER: {
                this.attributes.put("register", new RegisterBean(this.formData));
                break;
            }
            case OAUTH_GRANT: {
                this.attributes.put("oauth", new OAuthGrantBean(this.accessCode, this.clientSession, client, this.realmRolesRequested, this.resourceRolesRequested, this.protocolMappersRequested, this.accessRequestMessage));
                this.attributes.put("advancedMsg", new AdvancedMessageFormatterMethod(locale, messagesBundle));
                break;
            }
            case CODE: {
                this.attributes.put("code", new CodeBean(this.accessCode, this.messageType == MessageType.ERROR ? this.getFirstMessageUnformatted() : null));
            }
        }
        if (this.status == null) {
            this.status = Response.Status.OK;
        }
        try {
            String result = this.freeMarker.processTemplate(this.attributes, Templates.getTemplate(page), theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)this.status).type("text/html").entity((Object)result);
            BrowserSecurityHeaderSetup.headers((Response.ResponseBuilder)builder, (RealmModel)realm);
            for (Map.Entry<String, String> entry : this.httpResponseHeaders.entrySet()) {
                builder.header(entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response createForm(String form) {
        Properties messagesBundle;
        Theme theme;
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = this.session.getContext().getClient();
        UriInfo uriInfo = this.session.getContext().getUri();
        MultivaluedMapImpl queryParameterMap = this.queryParams != null ? this.queryParams : new MultivaluedMapImpl();
        String requestURI = uriInfo.getBaseUri().getPath();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)requestURI);
        for (String k : queryParameterMap.keySet()) {
            Object[] objects = ((List)queryParameterMap.get((Object)k)).toArray();
            if (objects.length == 1 && objects[0] == null) continue;
            uriBuilder.replaceQueryParam(k, objects);
        }
        if (this.accessCode != null) {
            uriBuilder.replaceQueryParam("code", new Object[]{this.accessCode});
        }
        URI baseUri = uriBuilder.build(new Object[0]);
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        try {
            theme = themeProvider.getTheme(realm.getLoginTheme(), Theme.Type.LOGIN);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        try {
            this.attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        if (client != null) {
            this.attributes.put("client", new ClientBean(client, baseUri));
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        try {
            messagesBundle = theme.getMessages(locale);
            this.attributes.put("msg", new MessageFormatterMethod(locale, messagesBundle));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messagesBundle = new Properties();
        }
        MessagesPerFieldBean messagesPerField = new MessagesPerFieldBean();
        if (this.messages != null) {
            MessageBean wholeMessage = new MessageBean(null, this.messageType);
            for (FormMessage message : this.messages) {
                String formattedMessageText = this.formatMessage(message, messagesBundle, locale);
                if (formattedMessageText == null) continue;
                wholeMessage.appendSummaryLine(formattedMessageText);
                messagesPerField.addMessage(message.getField(), formattedMessageText, this.messageType);
            }
            this.attributes.put("message", wholeMessage);
        }
        this.attributes.put("messagesPerField", messagesPerField);
        if (this.status == null) {
            this.status = Response.Status.OK;
        }
        if (realm != null) {
            this.attributes.put("realm", new RealmBean(realm));
            List<IdentityProviderModel> identityProviders = realm.getIdentityProviders();
            identityProviders = LoginFormsUtil.filterIdentityProviders(identityProviders, this.session, realm, this.attributes, this.formData);
            this.attributes.put("social", new IdentityProviderBean(realm, identityProviders, baseUri, uriInfo));
            this.attributes.put("url", new UrlBean(realm, theme, baseUri, this.actionUri));
            this.attributes.put("requiredActionUrl", new RequiredActionUrlFormatterMethod(realm, baseUri));
            if (realm.isInternationalizationEnabled()) {
                UriBuilder b = UriBuilder.fromUri((URI)baseUri).path(uriInfo.getPath());
                this.attributes.put("locale", new LocaleBean(realm, locale, b, messagesBundle));
            }
        }
        if (realm != null && this.user != null && this.session != null) {
            this.attributes.put("authenticatorConfigured", new AuthenticatorConfiguredMethod(realm, this.user, this.session));
        }
        try {
            String result = this.freeMarker.processTemplate(this.attributes, form, theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)this.status).type("text/html").entity((Object)result);
            BrowserSecurityHeaderSetup.headers((Response.ResponseBuilder)builder, (RealmModel)realm);
            for (Map.Entry<String, String> entry : this.httpResponseHeaders.entrySet()) {
                builder.header(entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response createLogin() {
        return this.createResponse(LoginFormsPages.LOGIN);
    }

    public Response createPasswordReset() {
        return this.createResponse(LoginFormsPages.LOGIN_RESET_PASSWORD);
    }

    public Response createLoginTotp() {
        return this.createResponse(LoginFormsPages.LOGIN_TOTP);
    }

    public Response createRegistration() {
        return this.createResponse(LoginFormsPages.REGISTER);
    }

    public Response createInfoPage() {
        return this.createResponse(LoginFormsPages.INFO);
    }

    public Response createUpdateProfilePage() {
        if (this.messageType != MessageType.ERROR) {
            this.setMessage(MessageType.WARNING, "updateProfileMessage", new Object[0]);
        }
        return this.createResponse(LoginFormsPages.LOGIN_UPDATE_PROFILE);
    }

    public Response createIdpLinkConfirmLinkPage() {
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_CONFIRM);
    }

    public Response createIdpLinkEmailPage() {
        BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
        String idpAlias = brokerContext.getIdpConfig().getAlias();
        idpAlias = ObjectUtil.capitalize((String)idpAlias);
        this.setMessage(MessageType.WARNING, "linkIdpMessage", idpAlias);
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_EMAIL);
    }

    public Response createErrorPage() {
        if (this.status == null) {
            this.status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return this.createResponse(LoginFormsPages.ERROR);
    }

    public Response createOAuthGrant(ClientSessionModel clientSession) {
        this.clientSession = clientSession;
        return this.createResponse(LoginFormsPages.OAUTH_GRANT);
    }

    public Response createCode() {
        return this.createResponse(LoginFormsPages.CODE);
    }

    protected void setMessage(MessageType type, String message, Object ... parameters) {
        this.messageType = type;
        this.messages = new ArrayList<FormMessage>();
        this.messages.add(new FormMessage(null, message, parameters));
    }

    protected String getFirstMessageUnformatted() {
        if (this.messages != null && !this.messages.isEmpty()) {
            return this.messages.get(0).getMessage();
        }
        return null;
    }

    protected String formatMessage(FormMessage message, Properties messagesBundle, Locale locale) {
        if (message == null) {
            return null;
        }
        if (messagesBundle.containsKey(message.getMessage())) {
            return new MessageFormat(messagesBundle.getProperty(message.getMessage()), locale).format(message.getParameters());
        }
        return message.getMessage();
    }

    public FreeMarkerLoginFormsProvider setError(String message, Object ... parameters) {
        this.setMessage(MessageType.ERROR, message, parameters);
        return this;
    }

    public LoginFormsProvider setErrors(List<FormMessage> messages) {
        if (messages == null) {
            return this;
        }
        this.messageType = MessageType.ERROR;
        this.messages = new ArrayList<FormMessage>(messages);
        return this;
    }

    public LoginFormsProvider addError(FormMessage errorMessage) {
        if (this.messageType != MessageType.ERROR) {
            this.messageType = null;
            this.messages = null;
        }
        if (this.messages == null) {
            this.messageType = MessageType.ERROR;
            this.messages = new LinkedList<FormMessage>();
        }
        this.messages.add(errorMessage);
        return this;
    }

    public LoginFormsProvider addSuccess(FormMessage errorMessage) {
        if (this.messageType != MessageType.SUCCESS) {
            this.messageType = null;
            this.messages = null;
        }
        if (this.messages == null) {
            this.messageType = MessageType.SUCCESS;
            this.messages = new LinkedList<FormMessage>();
        }
        this.messages.add(errorMessage);
        return this;
    }

    public FreeMarkerLoginFormsProvider setSuccess(String message, Object ... parameters) {
        this.setMessage(MessageType.SUCCESS, message, parameters);
        return this;
    }

    public FreeMarkerLoginFormsProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public FreeMarkerLoginFormsProvider setFormData(MultivaluedMap<String, String> formData) {
        this.formData = formData;
        return this;
    }

    public LoginFormsProvider setClientSessionCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    public LoginFormsProvider setClientSession(ClientSessionModel clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    public LoginFormsProvider setAccessRequest(List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested, List<ProtocolMapperModel> protocolMappersRequested) {
        this.realmRolesRequested = realmRolesRequested;
        this.resourceRolesRequested = resourceRolesRequested;
        this.protocolMappersRequested = protocolMappersRequested;
        return this;
    }

    public LoginFormsProvider setAccessRequest(String accessRequestMessage) {
        this.accessRequestMessage = accessRequestMessage;
        return this;
    }

    public LoginFormsProvider setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public LoginFormsProvider setStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public LoginFormsProvider setActionUri(URI actionUri) {
        this.actionUri = actionUri;
        return this;
    }

    public LoginFormsProvider setResponseHeader(String headerName, String headerValue) {
        this.httpResponseHeaders.put(headerName, headerValue);
        return this;
    }

    public void close() {
    }
}

