/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;

public class LoginFormUsernameAuthenticator
implements Authenticator {
    protected AuthenticatorModel model;

    public LoginFormUsernameAuthenticator(AuthenticatorModel model) {
        this.model = model;
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        if (!this.isActionUrl(context)) {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            String loginHint = context.getClientSession().getNote("login_hint");
            if (loginHint == null && (loginHint = AuthenticationManager.getRememberMeUsername(context.getRealm(), context.getHttpRequest().getHttpHeaders())) != null) {
                formData.add((Object)"rememberMe", (Object)"on");
            }
            if (loginHint != null) {
                formData.add((Object)"username", (Object)loginHint);
            }
            Response challengeResponse = this.challenge(context, (MultivaluedMap<String, String>)formData);
            context.challenge(challengeResponse);
            return;
        }
        this.validateUser(context);
    }

    protected boolean isActionUrl(AuthenticatorContext context) {
        URI expected = LoginActionsService.authenticationFormProcessor(context.getUriInfo()).build(new Object[]{context.getRealm().getName()});
        String current = context.getUriInfo().getAbsolutePath().getPath();
        String expectedPath = expected.getPath();
        return expectedPath.equals(current);
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    protected Response challenge(AuthenticatorContext context, MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = this.loginForm(context);
        if (formData.size() > 0) {
            forms.setFormData(formData);
        }
        return forms.createLogin();
    }

    protected LoginFormsProvider loginForm(AuthenticatorContext context) {
        ClientSessionCode code = new ClientSessionCode(context.getRealm(), context.getClientSession());
        code.setAction(ClientSessionModel.Action.AUTHENTICATE);
        URI action = LoginActionsService.authenticationFormProcessor(context.getUriInfo()).queryParam("code", new Object[]{code.getCode()}).build(new Object[]{context.getRealm().getName()});
        return ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setActionUri(action).setClientSessionCode(code.getCode());
    }

    protected Response invalidUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("invalidUserMessage", new Object[0]).createLogin();
    }

    protected Response disabledUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("accountDisabledMessage", new Object[0]).createLogin();
    }

    protected Response temporarilyDisabledUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("accountTemporarilyDisabledMessage", new Object[0]).createLogin();
    }

    public void validateUser(AuthenticatorContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getFormParameters();
        String username = (String)inputData.getFirst((Object)"username");
        if (username == null) {
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_USER, challengeResponse);
            return;
        }
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
        if (this.invalidUser(context, user)) {
            return;
        }
        context.setUser(user);
        context.success();
    }

    public boolean invalidUser(AuthenticatorContext context, UserModel user) {
        if (user == null) {
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_USER, challengeResponse);
            return true;
        }
        if (!user.isEnabled()) {
            Response challengeResponse = this.disabledUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.USER_DISABLED, challengeResponse);
            return true;
        }
        if (context.getRealm().isBruteForceProtected() && context.getProtector().isTemporarilyDisabled(context.getSession(), context.getRealm(), user.getUsername())) {
            Response challengeResponse = this.temporarilyDisabledUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.USER_TEMPORARILY_DISABLED, challengeResponse);
            return true;
        }
        return false;
    }

    public Response challenge(AuthenticatorContext context) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        return this.challenge(context, (MultivaluedMap<String, String>)formData);
    }

    @Override
    public boolean configuredFor(UserModel user) {
        return true;
    }

    @Override
    public String getRequiredAction() {
        return null;
    }

    public void close() {
    }
}

