/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class ReadonlyLDAPUserModelDelegate
extends UserModelDelegate
implements UserModel {
    protected LDAPFederationProvider provider;

    public ReadonlyLDAPUserModelDelegate(UserModel delegate, LDAPFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void setUsername(String username) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }

    public void setLastName(String lastName) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }

    public void setFirstName(String first) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }

    public void updateCredential(UserCredentialModel cred) {
        if (this.provider.getSupportedCredentialTypes(this.delegate).contains(cred.getType())) {
            throw new ModelReadOnlyException("Federated storage is not writable");
        }
        this.delegate.updateCredential(cred);
    }

    public void setEmail(String email) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }
}

