/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.idm.model.LDAPDn;

public class LDAPObject {
    private static final Logger logger = Logger.getLogger(LDAPObject.class);
    private String uuid;
    private LDAPDn dn;
    private String rdnAttributeName;
    private final List<String> objectClasses = new LinkedList<String>();
    private final List<String> readOnlyAttributeNames = new LinkedList<String>();
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> lowerCasedAttributes = new HashMap<String, Set<String>>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public LDAPDn getDn() {
        return this.dn;
    }

    public void setDn(LDAPDn dn) {
        this.dn = dn;
    }

    public List<String> getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.clear();
        this.objectClasses.addAll(objectClasses);
    }

    public List<String> getReadOnlyAttributeNames() {
        return this.readOnlyAttributeNames;
    }

    public void addReadOnlyAttributeName(String readOnlyAttribute) {
        this.readOnlyAttributeNames.add(readOnlyAttribute.toLowerCase());
    }

    public String getRdnAttributeName() {
        return this.rdnAttributeName;
    }

    public void setRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeName = rdnAttributeName;
    }

    public void setSingleAttribute(String attributeName, String attributeValue) {
        LinkedHashSet<String> asSet = new LinkedHashSet<String>();
        asSet.add(attributeValue);
        this.setAttribute(attributeName, asSet);
    }

    public void setAttribute(String attributeName, Set<String> attributeValue) {
        this.attributes.put(attributeName, attributeValue);
        this.lowerCasedAttributes.put(attributeName.toLowerCase(), attributeValue);
    }

    public String getAttributeAsString(String name) {
        Set<String> attrValue = this.lowerCasedAttributes.get(name.toLowerCase());
        if (attrValue == null || attrValue.size() == 0) {
            return null;
        }
        if (attrValue.size() > 1) {
            logger.warnf("Expected String but attribute '%s' has more values '%s' on object '%s' . Returning just first value", (Object)name, attrValue, (Object)this.dn);
        }
        return attrValue.iterator().next();
    }

    public Set<String> getAttributeAsSet(String name) {
        Set<String> values = this.lowerCasedAttributes.get(name.toLowerCase());
        return values == null ? null : new LinkedHashSet<String>(values);
    }

    public Map<String, Set<String>> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LDAPObject other = (LDAPObject)obj;
        return this.getUuid() != null && other.getUuid() != null && this.getUuid().equals(other.getUuid());
    }

    public int hashCode() {
        int result = this.getUuid() != null ? this.getUuid().hashCode() : 0;
        result = 31 * result + (this.getUuid() != null ? this.getUuid().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LDAP Object [ dn: " + this.dn + " , uuid: " + this.uuid + ", attributes: " + this.attributes + ", readOnly attribute names: " + this.readOnlyAttributeNames + " ]";
    }
}

