/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.verifytest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.exception.UnexpectedLiquibaseSdkException;
import liquibase.sdk.verifytest.OutputFormat;
import liquibase.sdk.verifytest.VerifiedTest;
import liquibase.sdk.verifytest.VerifiedTestFactory;
import liquibase.util.MD5Util;
import liquibase.util.StringUtils;

public class TestPermutation {
    private String notRanMessage;
    private SortedMap<String, Value> data = new TreeMap<String, Value>();
    private SortedMap<String, Value> description = new TreeMap<String, Value>();
    private String group;
    private TreeMap<String, Value> rowDescription;
    private String rowDescriptionParameter;
    private String rowFullKey = "";
    private String key = "";
    private String tableKey = "";
    private String fullKey = "";
    private SortedMap<String, Value> notes = new TreeMap<String, Value>();
    private List<Setup> setupCommands = new ArrayList<Setup>();
    private List<Verification> verifications = new ArrayList<Verification>();
    private List<Cleanup> cleanupCommands = new ArrayList<Cleanup>();
    private boolean valid = true;
    private boolean verified = false;
    private boolean canVerify;
    public static OkResult OK = new OkResult();

    public TestPermutation(VerifiedTest test) {
        test.addPermutation(this);
    }

    public String getKey() {
        return this.key;
    }

    public boolean getCanVerify() {
        return this.canVerify;
    }

    public void setCanVerify(boolean canVerify) {
        this.canVerify = canVerify;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getNotRanMessage() {
        return this.notRanMessage;
    }

    public void setNotRanMessage(String notRanMessage) {
        this.notRanMessage = notRanMessage;
    }

    public List<Setup> getSetup() {
        return this.setupCommands;
    }

    public void addAssertion(Setup setup) {
        this.setupCommands.add(setup);
    }

    public void addSetup(Setup setup) {
        this.setupCommands.add(setup);
    }

    public SortedMap<String, Value> getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public String getRowDescriptionParameter() {
        return this.rowDescriptionParameter;
    }

    public Map<String, Value> getRowDescription() {
        return this.rowDescription;
    }

    public String getRowFullKey() {
        return this.rowFullKey;
    }

    public String getFullKey() {
        return this.fullKey;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public SortedMap<String, Value> getNotes() {
        return this.notes;
    }

    public SortedMap<String, Value> getData() {
        return this.data;
    }

    public void describe(String key, Object value) {
        this.describe(key, value, OutputFormat.DefaultFormat);
    }

    public void describe(String key, Object value, OutputFormat outputFormat) {
        this.description.put(key, new Value(value, outputFormat));
        this.recomputeKey();
    }

    public void describeAsGroup(String key, Object value) {
        this.describeAsGroup(key, value, OutputFormat.DefaultFormat);
    }

    public void describeAsGroup(String key, Object value, OutputFormat outputFormat) {
        this.group = key + ": " + outputFormat.format(value);
        this.describe(key, value);
    }

    public void describeAsTable(String key, Map value) {
        this.describeAsTable(key, value, OutputFormat.DefaultFormat);
    }

    public void describeAsTable(String key, Map<String, ?> value, OutputFormat outputFormat) {
        this.rowDescriptionParameter = key;
        this.rowDescription = new TreeMap();
        for (Map.Entry<String, ?> entry : value.entrySet()) {
            this.rowDescription.put(entry.getKey(), new Value(entry.getValue(), outputFormat));
        }
        this.recomputeKey();
    }

    protected void recomputeKey() {
        TreeMap<String, Value> fullDescription = new TreeMap<String, Value>(this.description);
        StringUtils.StringUtilsFormatter formatter = new StringUtils.StringUtilsFormatter(){

            public String toString(Object obj) {
                return ((Value)obj).serialize();
            }
        };
        if (this.rowDescription != null) {
            for (Map.Entry<String, Value> rowEntry : this.rowDescription.entrySet()) {
                fullDescription.put(rowEntry.getKey(), rowEntry.getValue());
            }
            this.rowFullKey = StringUtils.join(this.rowDescription, ",", formatter);
        }
        this.tableKey = StringUtils.join(this.description, ",", formatter);
        this.fullKey = StringUtils.join(fullDescription, ",", formatter);
        this.key = MD5Util.computeMD5(this.fullKey).substring(0, 16);
    }

    public void note(String key, Object value) {
        this.note(key, value, OutputFormat.DefaultFormat);
    }

    public void note(String key, Object value, OutputFormat outputFormat) {
        this.notes.put(key, new Value(value, outputFormat));
    }

    public void data(String key, Object value) {
        this.data(key, value, OutputFormat.DefaultFormat);
    }

    public void data(String key, Object value, OutputFormat outputFormat) {
        this.data.put(key, new Value(value, outputFormat));
    }

    public List<Verification> getVerifications() {
        return this.verifications;
    }

    public void addVerification(Verification verification) {
        this.verifications.add(verification);
    }

    public List<Cleanup> getCleanup() {
        return this.cleanupCommands;
    }

    public void addCleanup(Cleanup cleanup) {
        this.cleanupCommands.add(cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(VerifiedTest test) throws Exception {
        TestPermutation previousRun = VerifiedTestFactory.getInstance().getSavedRun(test, this);
        if (this.notRanMessage != null) {
            this.save(test);
            return;
        }
        try {
            for (Setup setup : this.setupCommands) {
                SetupResult result = setup.run();
                if (result == null) {
                    throw new UnexpectedLiquibaseException("No result returned by setup");
                }
                if (!result.isValid()) {
                    this.valid = false;
                    this.canVerify = false;
                    this.notRanMessage = result.getMessage();
                    break;
                }
                if (result.canVerify()) continue;
                this.canVerify = false;
                this.notRanMessage = result.getMessage();
            }
        }
        catch (Throwable e) {
            TreeMap<String, Value> fullDescription = new TreeMap<String, Value>(this.description);
            if (this.rowDescription != null) {
                fullDescription.putAll(this.rowDescription);
            }
            String message = "Error executing setup\nDescription: " + this.output(fullDescription) + "\n" + "Notes: " + this.output(this.notes) + "\n" + "Data: " + this.output(this.data);
            throw new RuntimeException(message, e);
        }
        if (!this.valid || !this.canVerify) {
            this.save(test);
            return;
        }
        Exception cleanupError = null;
        try {
            try {
                for (Verification verification : this.verifications) {
                    verification.run();
                }
            }
            catch (CannotVerifyException e) {
                this.verified = false;
            }
            catch (Throwable e) {
                String message = "Error executing verification\nDescription: " + this.output(this.description) + "\n" + (this.rowDescription == null ? "" : "Row Description: " + this.output(this.rowDescription) + "\n") + "Notes: " + this.output(this.notes) + "\n" + "Data: " + this.output(this.data);
                throw new RuntimeException(message, e);
            }
            this.verified = true;
        }
        catch (Throwable throwable) {
            for (Cleanup cleanup : this.cleanupCommands) {
                try {
                    cleanup.run();
                }
                catch (Exception e) {
                    cleanupError = e;
                }
            }
            throw throwable;
        }
        for (Cleanup cleanup : this.cleanupCommands) {
            try {
                cleanup.run();
            }
            catch (Exception e) {
                cleanupError = e;
            }
        }
        if (cleanupError != null) {
            throw new UnexpectedLiquibaseSdkException("Cleanup error", cleanupError);
        }
        this.save(test);
    }

    protected void save(VerifiedTest test) throws Exception {
        VerifiedTestFactory.getInstance().saveRun(test, this);
    }

    private String output(SortedMap<String, Value> map) {
        ArrayList<String> out = new ArrayList<String>();
        for (Map.Entry<String, Value> entry : map.entrySet()) {
            out.add(entry.getKey() + "=" + entry.getValue().serialize());
        }
        return StringUtils.join(out, ", ");
    }

    public boolean getVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public static class Value {
        private Object value;
        private OutputFormat format;
        private String stringValue;

        public Value(Object value, OutputFormat format) {
            this.value = value;
            this.format = format;
        }

        public Object getValue() {
            return this.value;
        }

        public String serialize() {
            if (this.stringValue == null) {
                this.stringValue = this.format.format(this.value);
            }
            return this.stringValue;
        }
    }

    public static class CannotVerifyException
    extends RuntimeException {
        public CannotVerifyException(String message) {
            super(message);
        }

        public CannotVerifyException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface Cleanup {
        public void run();
    }

    public static interface Verification {
        public void run();
    }

    public static interface Setup {
        public SetupResult run();
    }

    public static class OkResult
    implements SetupResult {
        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean canVerify() {
            return true;
        }

        @Override
        public String getMessage() {
            return null;
        }
    }

    public static class CannotVerify
    implements SetupResult {
        private String message;

        public CannotVerify(String message) {
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean canVerify() {
            return false;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class Invalid
    implements SetupResult {
        private String message;

        public Invalid(String message) {
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean canVerify() {
            return false;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static interface SetupResult {
        public boolean isValid();

        public boolean canVerify();

        public String getMessage();
    }
}

