/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionStatus {
    protected BackgroundUpdater _updater;
    protected final Mongo _mongo;
    protected final List<ServerAddress> _mongosAddresses;
    protected volatile boolean _closed;
    protected final MongoOptions _mongoOptions = mongoOptionsDefaults.copy();
    protected static int updaterIntervalMS;
    protected static int updaterIntervalNoMasterMS;
    protected static final MongoOptions mongoOptionsDefaults;
    protected static final float latencySmoothFactor;
    protected static final DBObject isMasterCmd;

    ConnectionStatus(List<ServerAddress> mongosAddresses, Mongo mongo) {
        this._mongoOptions.socketFactory = mongo._options.socketFactory;
        this._mongosAddresses = new ArrayList<ServerAddress>(mongosAddresses);
        this._mongo = mongo;
    }

    void start() {
        if (this._updater != null) {
            this._updater.start();
        }
    }

    void close() {
        this._closed = true;
        if (this._updater != null) {
            this._updater.interrupt();
        }
    }

    abstract List<ServerAddress> getServerAddressList();

    abstract boolean hasServerUp();

    abstract Node ensureMaster();

    void checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("ReplicaSetStatus closed");
        }
    }

    static {
        mongoOptionsDefaults = new MongoOptions();
        isMasterCmd = new BasicDBObject("ismaster", (Object)1);
        updaterIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "5000"));
        updaterIntervalNoMasterMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalNoMasterMS", "10"));
        ConnectionStatus.mongoOptionsDefaults.connectTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000"));
        ConnectionStatus.mongoOptionsDefaults.socketTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000"));
        latencySmoothFactor = Float.parseFloat(System.getProperty("com.mongodb.latencySmoothFactor", "4"));
    }

    static abstract class UpdatableNode {
        final ServerAddress _addr;
        final MongoOptions _mongoOptions;
        final Mongo _mongo;
        DBPort _port;
        float _pingTimeMS = 0.0f;
        int _maxBsonObjectSize;
        ConnectionState _connectionState = ConnectionState.Connecting;

        UpdatableNode(ServerAddress addr, Mongo mongo, MongoOptions mongoOptions) {
            this._addr = addr;
            this._mongo = mongo;
            this._mongoOptions = mongoOptions;
            this._port = new DBPort(addr, null, mongoOptions);
        }

        public boolean isOk() {
            return this._connectionState == ConnectionState.Connected;
        }

        public CommandResult update() {
            try {
                long start = System.nanoTime();
                CommandResult res = this._port.runCommand(this._mongo.getDB("admin"), isMasterCmd);
                long end = System.nanoTime();
                float newPingMS = (float)(end - start) / 1000000.0f;
                this._pingTimeMS = this._connectionState != ConnectionState.Connected ? newPingMS : (this._pingTimeMS += (newPingMS - this._pingTimeMS) / latencySmoothFactor);
                this._maxBsonObjectSize = res.getInt("maxBsonObjectSize", 0x400000);
                if (this._connectionState != ConnectionState.Connected) {
                    this._connectionState = ConnectionState.Connected;
                    this.getLogger().log(Level.INFO, "Server seen up: " + this._addr);
                }
                this.getLogger().log(Level.FINE, "Latency to " + this._addr + " actual=" + newPingMS + " smoothed=" + this._pingTimeMS);
                return res;
            }
            catch (Exception e) {
                if (this._connectionState != ConnectionState.Unconnected) {
                    this._connectionState = ConnectionState.Unconnected;
                    this.getLogger().log(Level.WARNING, String.format("Server seen down: %s", this._addr), e);
                }
                return null;
            }
        }

        protected abstract Logger getLogger();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ConnectionState {
            Connecting,
            Connected,
            Unconnected;

        }
    }

    static class BackgroundUpdater
    extends Thread {
        public BackgroundUpdater(String name) {
            super(name);
            this.setDaemon(true);
        }
    }

    static class Node {
        protected final ServerAddress _addr;
        protected final float _pingTime;
        protected final boolean _ok;
        protected final int _maxBsonObjectSize;

        Node(float pingTime, ServerAddress addr, int maxBsonObjectSize, boolean ok) {
            this._pingTime = pingTime;
            this._addr = addr;
            this._maxBsonObjectSize = maxBsonObjectSize;
            this._ok = ok;
        }

        public boolean isOk() {
            return this._ok;
        }

        public int getMaxBsonObjectSize() {
            return this._maxBsonObjectSize;
        }

        public ServerAddress getServerAddress() {
            return this._addr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this._maxBsonObjectSize != node._maxBsonObjectSize) {
                return false;
            }
            if (this._ok != node._ok) {
                return false;
            }
            if (Float.compare(node._pingTime, this._pingTime) != 0) {
                return false;
            }
            return this._addr.equals(node._addr);
        }

        public int hashCode() {
            int result = this._addr.hashCode();
            result = 31 * result + (this._pingTime != 0.0f ? Float.floatToIntBits(this._pingTime) : 0);
            result = 31 * result + (this._ok ? 1 : 0);
            result = 31 * result + this._maxBsonObjectSize;
            return result;
        }

        public String toJSON() {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            buf.append("address:'").append(this._addr).append("', ");
            buf.append("ok:").append(this._ok).append(", ");
            buf.append("ping:").append(this._pingTime).append(", ");
            buf.append("maxBsonObjectSize:").append(this._maxBsonObjectSize).append(", ");
            buf.append("}");
            return buf.toString();
        }
    }
}

