/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v1.writers;

import java.net.URI;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v1.assertion.SAML11ActionType;
import org.keycloak.dom.saml.v1.assertion.SAML11AdviceType;
import org.keycloak.dom.saml.v1.assertion.SAML11AssertionType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeType;
import org.keycloak.dom.saml.v1.assertion.SAML11AudienceRestrictionCondition;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthorityBindingType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthorizationDecisionStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionAbstractType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionsType;
import org.keycloak.dom.saml.v1.assertion.SAML11EvidenceType;
import org.keycloak.dom.saml.v1.assertion.SAML11NameIdentifierType;
import org.keycloak.dom.saml.v1.assertion.SAML11StatementAbstractType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectLocalityType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.saml.v1.writers.BaseSAML11Writer;
import org.w3c.dom.Element;

public class SAML11AssertionWriter
extends BaseSAML11Writer {
    String ns = "urn:oasis:names:tc:SAML:1.0:assertion";

    public SAML11AssertionWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(SAML11AssertionType assertion) throws ProcessingException {
        Element element;
        SAML11AdviceType advice;
        SAML11ConditionsType conditions;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ASSERTION.get(), this.ns);
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, this.ns);
        StaxUtil.writeDefaultNameSpace(this.writer, this.ns);
        StaxUtil.writeAttribute(this.writer, "AssertionID", assertion.getID());
        StaxUtil.writeAttribute(this.writer, "MajorVersion", assertion.getMajorVersion() + "");
        StaxUtil.writeAttribute(this.writer, "MinorVersion", assertion.getMinorVersion() + "");
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), assertion.getIssueInstant().toString());
        String issuer = assertion.getIssuer();
        if (issuer != null) {
            StaxUtil.writeAttribute(this.writer, "Issuer", issuer);
        }
        if ((conditions = assertion.getConditions()) != null) {
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.CONDITIONS.get(), this.ns);
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_BEFORE.get(), conditions.getNotBefore().toString());
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_ON_OR_AFTER.get(), conditions.getNotOnOrAfter().toString());
            List<SAML11ConditionAbstractType> typeOfConditions = conditions.get();
            if (typeOfConditions != null) {
                for (SAML11ConditionAbstractType sAML11ConditionAbstractType : typeOfConditions) {
                    if (!(sAML11ConditionAbstractType instanceof SAML11AudienceRestrictionCondition)) continue;
                    SAML11AudienceRestrictionCondition art = (SAML11AudienceRestrictionCondition)sAML11ConditionAbstractType;
                    StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "AudienceRestrictionCondition", this.ns);
                    List<URI> audiences = art.get();
                    if (audiences != null) {
                        for (URI audience : audiences) {
                            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUDIENCE.get(), this.ns);
                            StaxUtil.writeCharacters(this.writer, audience.toString());
                            StaxUtil.writeEndElement(this.writer);
                        }
                    }
                    StaxUtil.writeEndElement(this.writer);
                }
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if ((advice = assertion.getAdvice()) != null) {
            throw logger.notImplementedYet("Advice");
        }
        List<SAML11StatementAbstractType> statements = assertion.getStatements();
        if (statements != null) {
            for (SAML11StatementAbstractType statement : statements) {
                if (statement instanceof SAML11AuthenticationStatementType) {
                    this.write((SAML11AuthenticationStatementType)statement);
                    continue;
                }
                if (statement instanceof SAML11AttributeStatementType) {
                    this.write((SAML11AttributeStatementType)statement);
                    continue;
                }
                if (statement instanceof SAML11AuthorizationDecisionStatementType) {
                    this.write((SAML11AuthorizationDecisionStatementType)statement);
                    continue;
                }
                if (statement instanceof SAML11SubjectStatementType) {
                    this.write((SAML11SubjectStatementType)statement);
                    continue;
                }
                throw logger.writerUnknownTypeError(statement.getClass().getName());
            }
        }
        if ((element = assertion.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, element);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatementAbstractType statement) throws ProcessingException {
        throw logger.notImplementedYet("StatementAbstractType");
    }

    public void write(SAML11SubjectStatementType statement) throws ProcessingException {
        throw logger.notImplementedYet("SAML11SubjectStatementType");
    }

    public void write(SAML11AttributeStatementType statement) throws ProcessingException {
        List<SAML11AttributeType> attributes;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE_STATEMENT.get(), "urn:oasis:names:tc:SAML:1.0:assertion");
        SAML11SubjectType subject = statement.getSubject();
        if (subject != null) {
            this.write(subject);
        }
        if ((attributes = statement.get()) != null) {
            for (SAML11AttributeType attr : attributes) {
                this.write(attr);
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11AuthenticationStatementType authnStatement) throws ProcessingException {
        SAML11SubjectLocalityType locality;
        SAML11SubjectType subject;
        URI authMethod;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "AuthenticationStatement", "urn:oasis:names:tc:SAML:1.0:assertion");
        XMLGregorianCalendar authnInstant = authnStatement.getAuthenticationInstant();
        if (authnInstant != null) {
            StaxUtil.writeAttribute(this.writer, "AuthenticationInstant", authnInstant.toString());
        }
        if ((authMethod = authnStatement.getAuthenticationMethod()) != null) {
            StaxUtil.writeAttribute(this.writer, "AuthenticationMethod", authMethod.toString());
        }
        if ((subject = authnStatement.getSubject()) != null) {
            this.write(subject);
        }
        if ((locality = authnStatement.getSubjectLocality()) != null) {
            this.write(locality);
        }
        List<SAML11AuthorityBindingType> authorities = authnStatement.getAuthorityBindingType();
        for (SAML11AuthorityBindingType authority : authorities) {
            this.write(authority);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11AuthorityBindingType authority) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "AuthorityBinding", "urn:oasis:names:tc:SAML:1.0:assertion");
        QName authorityKind = authority.getAuthorityKind();
        StaxUtil.writeAttribute(this.writer, "AuthorityKind", authorityKind);
        String binding = authority.getBinding().toString();
        StaxUtil.writeAttribute(this.writer, "Binding", binding);
        String location = authority.getLocation().toString();
        StaxUtil.writeAttribute(this.writer, "Location", location);
        StaxUtil.writeEndElement(this.writer);
    }

    public void write(SAML11SubjectLocalityType locality) throws ProcessingException {
        String dns;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.SUBJECT_LOCALITY.get(), "urn:oasis:names:tc:SAML:1.0:assertion");
        String ip = locality.getIpAddress();
        if (StringUtil.isNotNull(ip)) {
            StaxUtil.writeAttribute(this.writer, "IPAddress", ip);
        }
        if (StringUtil.isNotNull(dns = locality.getDnsAddress())) {
            StaxUtil.writeAttribute(this.writer, "DNSAddress", dns);
        }
        StaxUtil.writeEndElement(this.writer);
    }

    public void write(SAML11AuthorizationDecisionStatementType xacmlStat) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "AuthorizationDecisionStatement", this.ns);
        String resource = xacmlStat.getResource().toString();
        StaxUtil.writeAttribute(this.writer, "Resource", resource);
        StaxUtil.writeAttribute(this.writer, "Decision", xacmlStat.getDecision().name());
        SAML11SubjectType subject = xacmlStat.getSubject();
        if (subject != null) {
            this.write(subject);
        }
        List<SAML11ActionType> actions = xacmlStat.getActions();
        for (SAML11ActionType action : actions) {
            this.write(action);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11SubjectType subject) throws ProcessingException {
        SAML11SubjectConfirmationType confirmation;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.SUBJECT.get(), "urn:oasis:names:tc:SAML:1.0:assertion");
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, this.ns);
        SAML11SubjectType.SAML11SubjectTypeChoice choice = subject.getChoice();
        if (choice != null) {
            SAML11SubjectConfirmationType confirmation2;
            SAML11NameIdentifierType nameid = choice.getNameID();
            if (nameid != null) {
                this.write(nameid);
            }
            if ((confirmation2 = choice.getSubjectConfirmation()) != null) {
                this.write(confirmation2);
            }
        }
        if ((confirmation = subject.getSubjectConfirmation()) != null) {
            this.write(confirmation);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11SubjectConfirmationType confirmation) throws ProcessingException {
        Object subjectConfirmationData;
        Element keyInfo;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.SUBJECT_CONFIRMATION.get(), "urn:oasis:names:tc:SAML:1.0:assertion");
        List<URI> confirmationMethods = confirmation.getConfirmationMethod();
        if (confirmationMethods != null) {
            for (URI confirmationMethod : confirmationMethods) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "ConfirmationMethod", "urn:oasis:names:tc:SAML:1.0:assertion");
                StaxUtil.writeCharacters(this.writer, confirmationMethod.toString());
                StaxUtil.writeEndElement(this.writer);
            }
        }
        if ((keyInfo = confirmation.getKeyInfo()) != null) {
            StaxUtil.writeDOMElement(this.writer, keyInfo);
        }
        if ((subjectConfirmationData = confirmation.getSubjectConfirmationData()) != null) {
            this.writeSubjectConfirmationData(subjectConfirmationData);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeSubjectConfirmationData(Object scData) throws ProcessingException {
        throw logger.notImplementedYet("SubjectConfirmationData");
    }

    public void write(SAML11NameIdentifierType nameid) throws ProcessingException {
        String nameQualifier;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "NameIdentifier", "urn:oasis:names:tc:SAML:1.0:assertion");
        URI format = nameid.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute(this.writer, "Format", format.toString());
        }
        if (StringUtil.isNotNull(nameQualifier = nameid.getNameQualifier())) {
            StaxUtil.writeAttribute(this.writer, "NameQualifier", nameQualifier);
        }
        StaxUtil.writeCharacters(this.writer, nameid.getValue());
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11AttributeType attributeType) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE.get(), this.ns);
        this.writeAttributeTypeWithoutRootTag(attributeType);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeAttributeTypeWithoutRootTag(SAML11AttributeType attributeType) throws ProcessingException {
        String attributeName = attributeType.getAttributeName();
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw logger.writerNullValueError("attribute name");
        }
        StaxUtil.writeAttribute(this.writer, "AttributeName", attributeName);
        String attributeNamespace = attributeType.getAttributeNamespace().toString();
        if (StringUtil.isNullOrEmpty(attributeNamespace)) {
            throw logger.writerNullValueError("attribute namespace");
        }
        StaxUtil.writeAttribute(this.writer, "AttributeNamespace", attributeNamespace);
        List<Object> attributeValues = attributeType.get();
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                if (attributeValue instanceof String) {
                    this.writeStringAttributeValue((String)attributeValue);
                    continue;
                }
                throw logger.writerUnsupportedAttributeValueError(attributeValue.getClass().getName());
            }
        }
    }

    public void writeStringAttributeValue(String attributeValue) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE_VALUE.get(), this.ns);
        StaxUtil.writeNameSpace(this.writer, JBossSAMLURIConstants.XSI_PREFIX.get(), JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "xs", JBossSAMLURIConstants.XMLSCHEMA_NSURI.get());
        StaxUtil.writeAttribute(this.writer, "xsi", JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xs:string");
        StaxUtil.writeCharacters(this.writer, attributeValue);
        StaxUtil.writeEndElement(this.writer);
    }

    public void writeLocalizedNameType(LocalizedNameType localizedNameType, QName startElement) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, startElement.getPrefix(), startElement.getLocalPart(), startElement.getNamespaceURI());
        StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XML.get(), "lang", "xml"), localizedNameType.getLang());
        StaxUtil.writeCharacters(this.writer, localizedNameType.getValue());
        StaxUtil.writeEndElement(this.writer);
    }

    public void write(SAML11ActionType action) throws ProcessingException {
        String val;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "Action", this.ns);
        String ns = action.getNamespace();
        if (StringUtil.isNotNull(ns)) {
            StaxUtil.writeAttribute(this.writer, "Namespace", ns);
        }
        if (StringUtil.isNotNull(val = action.getValue())) {
            StaxUtil.writeCharacters(this.writer, val);
        }
        StaxUtil.writeEndElement(this.writer);
    }

    public void write(SAML11EvidenceType evidence) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "Evidence", this.ns);
        List<String> assertionIDRefs = evidence.getAssertionIDReference();
        for (String assertionIDRef : assertionIDRefs) {
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "AssertionIDReference", this.ns);
            StaxUtil.writeCharacters(this.writer, assertionIDRef);
            StaxUtil.writeEndElement(this.writer);
        }
        List<SAML11AssertionType> assertions = evidence.getAssertions();
        for (SAML11AssertionType assertion : assertions) {
            this.write(assertion);
        }
        StaxUtil.writeEndElement(this.writer);
    }
}

