/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos.impl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.models.ModelException;

public class KerberosUsernamePasswordAuthenticator {
    private static final Logger logger = Logger.getLogger(KerberosUsernamePasswordAuthenticator.class);
    private final CommonKerberosConfig config;
    private LoginContext loginContext;

    public KerberosUsernamePasswordAuthenticator(CommonKerberosConfig config) {
        this.config = config;
    }

    public boolean isUserAvailable(String username) {
        logger.debug((Object)("Checking existence of user: " + username));
        try {
            String principal = this.getKerberosPrincipal(username);
            this.loginContext = new LoginContext("does-not-matter", null, this.createJaasCallbackHandler(principal, "fake-password-which-nobody-has"), this.createJaasConfiguration());
            this.loginContext.login();
            throw new IllegalStateException("Didn't expect to end here");
        }
        catch (LoginException le) {
            String message = le.getMessage();
            logger.debug((Object)("Message from kerberos: " + message));
            this.checkKerberosServerAvailable(le);
            boolean exists = !message.contains("Client not found");
            return exists;
        }
    }

    public boolean validUser(String username, String password) {
        try {
            this.authenticateSubject(username, password);
            this.logoutSubject();
            return true;
        }
        catch (LoginException le) {
            this.checkKerberosServerAvailable(le);
            logger.debug((Object)("Failed to authenticate user " + username), (Throwable)le);
            return false;
        }
    }

    protected void checkKerberosServerAvailable(LoginException le) {
        if (le.getMessage().contains("Port Unreachable")) {
            throw new ModelException("Kerberos unreachable", (Throwable)le);
        }
    }

    public Subject authenticateSubject(String username, String password) throws LoginException {
        String principal = this.getKerberosPrincipal(username);
        logger.debug((Object)("Validating password of principal: " + principal));
        this.loginContext = new LoginContext("does-not-matter", null, this.createJaasCallbackHandler(principal, password), this.createJaasConfiguration());
        this.loginContext.login();
        logger.debug((Object)("Principal " + principal + " authenticated succesfully"));
        return this.loginContext.getSubject();
    }

    public void logoutSubject() {
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException le) {
                logger.error((Object)"Failed to logout kerberos subject", (Throwable)le);
            }
        }
    }

    protected String getKerberosPrincipal(String username) throws LoginException {
        if (username.contains("@")) {
            String[] tokens = username.split("@");
            String kerberosRealm = tokens[1];
            if (!kerberosRealm.toUpperCase().equals(this.config.getKerberosRealm())) {
                logger.warn((Object)("Invalid kerberos realm. Expected realm: " + this.config.getKerberosRealm() + ", username: " + username));
                throw new LoginException("Client not found");
            }
            username = tokens[0];
        }
        return username + "@" + this.config.getKerberosRealm();
    }

    protected CallbackHandler createJaasCallbackHandler(final String principal, final String password) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(principal);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        passwordCallback.setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unsupported callback: " + callback.getClass().getCanonicalName());
                }
            }
        };
    }

    protected Configuration createJaasConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("storeKey", "true");
                options.put("debug", String.valueOf(KerberosUsernamePasswordAuthenticator.this.config.getDebug()));
                AppConfigurationEntry kerberosLMConfiguration = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{kerberosLMConfiguration};
            }
        };
    }
}

