/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.api.MongoCollection;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.connections.mongo.api.context.MongoTask;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;
import org.keycloak.connections.mongo.api.types.MapperRegistry;
import org.keycloak.connections.mongo.impl.EntityInfo;
import org.keycloak.connections.mongo.impl.types.BasicDBListMapper;
import org.keycloak.connections.mongo.impl.types.BasicDBListToSetMapper;
import org.keycloak.connections.mongo.impl.types.BasicDBObjectMapper;
import org.keycloak.connections.mongo.impl.types.BasicDBObjectToMapMapper;
import org.keycloak.connections.mongo.impl.types.EnumToStringMapper;
import org.keycloak.connections.mongo.impl.types.ListMapper;
import org.keycloak.connections.mongo.impl.types.MapMapper;
import org.keycloak.connections.mongo.impl.types.MongoEntityMapper;
import org.keycloak.connections.mongo.impl.types.SimpleMapper;
import org.keycloak.connections.mongo.impl.types.StringToEnumMapper;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyQueries;

public class MongoStoreImpl
implements MongoStore {
    private static final Class<?>[] SIMPLE_TYPES = new Class[]{String.class, Integer.class, Boolean.class, Long.class, Double.class, Character.class, Date.class, byte[].class};
    private final DB database;
    private static final Logger logger = Logger.getLogger(MongoStoreImpl.class);
    private final MapperRegistry mapperRegistry;
    private ConcurrentMap<Class<?>, EntityInfo> entityInfoCache = new ConcurrentHashMap();

    public MongoStoreImpl(DB database, Class<?>[] managedEntityTypes) {
        this.database = database;
        this.mapperRegistry = new MapperRegistry();
        for (Class<?> simpleMapperClass : SIMPLE_TYPES) {
            SimpleMapper mapper = new SimpleMapper(simpleMapperClass);
            this.mapperRegistry.addAppObjectMapper(mapper);
            this.mapperRegistry.addDBObjectMapper(mapper);
        }
        this.mapperRegistry.addAppObjectMapper(new ListMapper<ArrayList>(this.mapperRegistry, ArrayList.class));
        this.mapperRegistry.addAppObjectMapper(new ListMapper<List>(this.mapperRegistry, List.class));
        this.mapperRegistry.addDBObjectMapper(new BasicDBListMapper(this.mapperRegistry));
        this.mapperRegistry.addAppObjectMapper(new ListMapper<HashSet>(this.mapperRegistry, HashSet.class));
        this.mapperRegistry.addAppObjectMapper(new ListMapper<Set>(this.mapperRegistry, Set.class));
        this.mapperRegistry.addDBObjectMapper(new BasicDBListToSetMapper(this.mapperRegistry));
        this.mapperRegistry.addAppObjectMapper(new MapMapper<HashMap>(this.mapperRegistry, HashMap.class));
        this.mapperRegistry.addAppObjectMapper(new MapMapper<Map>(this.mapperRegistry, Map.class));
        this.mapperRegistry.addDBObjectMapper(new BasicDBObjectToMapMapper(this.mapperRegistry));
        this.mapperRegistry.addAppObjectMapper(new EnumToStringMapper());
        this.mapperRegistry.addDBObjectMapper(new StringToEnumMapper());
        for (Class<?> type : managedEntityTypes) {
            this.getEntityInfo(type);
            this.mapperRegistry.addAppObjectMapper(new MongoEntityMapper(this, this.mapperRegistry, type));
            this.mapperRegistry.addDBObjectMapper(new BasicDBObjectMapper(this, this.mapperRegistry, type));
        }
    }

    protected void dropDatabase() {
        this.database.dropDatabase();
        logger.info((Object)("Database " + this.database.getName() + " dropped in MongoDB"));
    }

    @Override
    public void insertEntity(MongoIdentifiableEntity entity, MongoStoreInvocationContext context) {
        Class<?> clazz = entity.getClass();
        EntityInfo entityInfo = this.getEntityInfo(clazz);
        BasicDBObject dbObject = this.mapperRegistry.convertApplicationObjectToDBObject(entity, BasicDBObject.class);
        DBCollection dbCollection = this.database.getCollection(entityInfo.getDbCollectionName());
        String currentId = entity.getId();
        if (currentId == null) {
            currentId = KeycloakModelUtils.generateId();
            entity.setId(currentId);
        }
        dbObject.put("_id", (Object)currentId);
        try {
            dbCollection.insert(new DBObject[]{dbObject});
        }
        catch (MongoException e) {
            throw MongoStoreImpl.convertException(e);
        }
        context.addCreatedEntity(entity);
    }

    public static ModelException convertException(MongoException e) {
        if (e instanceof MongoException.DuplicateKey) {
            return new ModelDuplicateException((Throwable)e);
        }
        return new ModelException((Throwable)e);
    }

    @Override
    public void updateEntity(final MongoIdentifiableEntity entity, MongoStoreInvocationContext context) {
        MongoTask fullUpdateTask = new MongoTask(){

            @Override
            public void execute() {
                Class<?> clazz = entity.getClass();
                EntityInfo entityInfo = MongoStoreImpl.this.getEntityInfo(clazz);
                BasicDBObject dbObject = MongoStoreImpl.this.mapperRegistry.convertApplicationObjectToDBObject(entity, BasicDBObject.class);
                DBCollection dbCollection = MongoStoreImpl.this.database.getCollection(entityInfo.getDbCollectionName());
                String currentId = entity.getId();
                if (currentId == null) {
                    throw new IllegalStateException("Can't update entity without id: " + entity);
                }
                BasicDBObject query = new BasicDBObject("_id", (Object)currentId);
                dbCollection.update((DBObject)query, (DBObject)dbObject);
            }

            @Override
            public boolean isFullUpdate() {
                return true;
            }
        };
        context.addUpdateTask(entity, fullUpdateTask);
    }

    @Override
    public <T extends MongoIdentifiableEntity> int updateEntities(Class<T> type, DBObject query, DBObject update, MongoStoreInvocationContext context) {
        context.beforeDBBulkUpdateOrRemove(type);
        DBCollection collection = this.getDBCollectionForType(type);
        WriteResult wr = collection.update(query, update, false, true);
        logger.debugf("Updated %d collections of type %s", (Object)wr.getN(), type);
        return wr.getN();
    }

    @Override
    public <T extends MongoIdentifiableEntity> T loadEntity(Class<T> type, String id, MongoStoreInvocationContext context) {
        BasicDBObject idQuery;
        T cached = context.getLoadedEntity(type, id);
        if (cached != null && type.isAssignableFrom(cached.getClass())) {
            return cached;
        }
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBObject dbObject = dbCollection.findOne((DBObject)(idQuery = new BasicDBObject("_id", (Object)id)));
        if (dbObject == null) {
            return null;
        }
        MapperContext<DBObject, T> mapperContext = new MapperContext<DBObject, T>(dbObject, type, null);
        MongoIdentifiableEntity converted = (MongoIdentifiableEntity)this.mapperRegistry.convertDBObjectToApplicationObject(mapperContext);
        context.addLoadedEntity(converted);
        return (T)converted;
    }

    @Override
    public <T extends MongoIdentifiableEntity> T loadSingleEntity(Class<T> type, DBObject query, MongoStoreInvocationContext context) {
        context.beforeDBSearch(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBObject dbObject = dbCollection.findOne(query);
        if (dbObject == null) {
            return null;
        }
        return this.convertDBObjectToEntity(type, dbObject, context);
    }

    @Override
    public <T extends MongoIdentifiableEntity> List<T> loadEntities(Class<T> type, DBObject query, MongoStoreInvocationContext context) {
        context.beforeDBSearch(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBCursor cursor = dbCollection.find(query);
        return this.convertCursor(type, cursor, context);
    }

    @Override
    public <T extends MongoIdentifiableEntity> List<T> loadEntities(Class<T> type, DBObject query, DBObject sort, int firstResult, int maxResults, MongoStoreInvocationContext context) {
        context.beforeDBSearch(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBCursor cursor = dbCollection.find(query);
        if (firstResult != -1) {
            cursor.skip(firstResult);
        }
        if (maxResults != -1) {
            cursor.limit(maxResults);
        }
        if (sort != null) {
            cursor.sort(sort);
        }
        return this.convertCursor(type, cursor, context);
    }

    @Override
    public <T extends MongoIdentifiableEntity> int countEntities(Class<T> type, DBObject query, MongoStoreInvocationContext context) {
        context.beforeDBSearch(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        Long count = dbCollection.count(query);
        return count.intValue();
    }

    @Override
    public boolean removeEntity(MongoIdentifiableEntity entity, MongoStoreInvocationContext context) {
        return this.removeEntity(entity.getClass(), entity.getId(), context);
    }

    @Override
    public boolean removeEntity(Class<? extends MongoIdentifiableEntity> type, String id, MongoStoreInvocationContext context) {
        MongoIdentifiableEntity found = this.loadEntity(type, id, context);
        if (found == null) {
            return false;
        }
        DBCollection dbCollection = this.getDBCollectionForType(type);
        BasicDBObject dbQuery = new BasicDBObject("_id", (Object)id);
        dbCollection.remove((DBObject)dbQuery);
        context.addRemovedEntity(found);
        return true;
    }

    @Override
    public int removeEntities(Class<? extends MongoIdentifiableEntity> type, DBObject query, boolean callback, MongoStoreInvocationContext context) {
        if (callback) {
            List<? extends MongoIdentifiableEntity> foundObjects = this.loadEntities(type, query, context);
            if (foundObjects.size() == 0) {
                return 0;
            }
            DBCollection dbCollection = this.getDBCollectionForType(type);
            dbCollection.remove(query);
            logger.debugf("Removed %d entities of type: %s, query: %s", (Object)foundObjects.size(), type, (Object)query);
            for (MongoIdentifiableEntity mongoIdentifiableEntity : foundObjects) {
                context.addRemovedEntity(mongoIdentifiableEntity);
            }
            return foundObjects.size();
        }
        context.beforeDBBulkUpdateOrRemove(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        WriteResult writeResult = dbCollection.remove(query);
        int removedCount = writeResult.getN();
        logger.debugf("Removed directly %d entities of type: %s, query: %s", (Object)removedCount, type, (Object)query);
        return removedCount;
    }

    @Override
    public <S> boolean pushItemToList(final MongoIdentifiableEntity entity, final String listPropertyName, S itemToPush, boolean skipIfAlreadyPresent, MongoStoreInvocationContext context) {
        final Class<?> type = entity.getClass();
        EntityInfo entityInfo = this.getEntityInfo(type);
        Property<Object> listProperty = entityInfo.getPropertyByName(listPropertyName);
        if (listProperty == null) {
            throw new IllegalArgumentException("Property " + listPropertyName + " doesn't exist on object " + entity);
        }
        ArrayList<S> list = (ArrayList<S>)listProperty.getValue((Object)entity);
        if (list == null) {
            list = new ArrayList<S>();
            listProperty.setValue((Object)entity, list);
        }
        if (skipIfAlreadyPresent && list.contains(itemToPush)) {
            return false;
        }
        list.add(itemToPush);
        final ArrayList<S> listt = list;
        context.addUpdateTask(entity, new MongoTask(){

            @Override
            public void execute() {
                BasicDBList dbList = MongoStoreImpl.this.mapperRegistry.convertApplicationObjectToDBObject(listt, BasicDBList.class);
                BasicDBObject query = new BasicDBObject("_id", (Object)entity.getId());
                BasicDBObject listObject = new BasicDBObject(listPropertyName, (Object)dbList);
                BasicDBObject setCommand = new BasicDBObject("$set", (Object)listObject);
                MongoStoreImpl.this.getDBCollectionForType(type).update((DBObject)query, (DBObject)setCommand);
            }

            @Override
            public boolean isFullUpdate() {
                return false;
            }
        });
        return true;
    }

    @Override
    public <S> boolean pullItemFromList(final MongoIdentifiableEntity entity, final String listPropertyName, final S itemToPull, MongoStoreInvocationContext context) {
        final Class<?> type = entity.getClass();
        EntityInfo entityInfo = this.getEntityInfo(type);
        Property<Object> listProperty = entityInfo.getPropertyByName(listPropertyName);
        if (listProperty == null) {
            throw new IllegalArgumentException("Property " + listPropertyName + " doesn't exist on object " + entity);
        }
        List list = (List)listProperty.getValue((Object)entity);
        if (list == null || !list.contains(itemToPull)) {
            return false;
        }
        list.remove(itemToPull);
        context.addUpdateTask(entity, new MongoTask(){

            @Override
            public void execute() {
                Object dbItemToPull = MongoStoreImpl.this.mapperRegistry.convertApplicationObjectToDBObject(itemToPull, Object.class);
                BasicDBObject query = new BasicDBObject("_id", (Object)entity.getId());
                BasicDBObject pullObject = new BasicDBObject(listPropertyName, dbItemToPull);
                BasicDBObject pullCommand = new BasicDBObject("$pull", (Object)pullObject);
                MongoStoreImpl.this.getDBCollectionForType(type).update((DBObject)query, (DBObject)pullCommand);
            }

            @Override
            public boolean isFullUpdate() {
                return false;
            }
        });
        return true;
    }

    public void addAppObjectConverter(Mapper<?, ?> mapper) {
        this.mapperRegistry.addAppObjectMapper(mapper);
    }

    public void addDBObjectConverter(Mapper<?, ?> mapper) {
        this.mapperRegistry.addDBObjectMapper(mapper);
    }

    public EntityInfo getEntityInfo(Class<?> entityClass) {
        EntityInfo entityInfo = (EntityInfo)this.entityInfoCache.get(entityClass);
        if (entityInfo == null) {
            Map properties = PropertyQueries.createQuery(entityClass).getWritableResultList();
            MongoCollection classAnnotation = entityClass.getAnnotation(MongoCollection.class);
            String dbCollectionName = classAnnotation == null ? null : classAnnotation.collectionName();
            entityInfo = new EntityInfo(entityClass, dbCollectionName, properties);
            EntityInfo existing = this.entityInfoCache.putIfAbsent(entityClass, entityInfo);
            if (existing != null) {
                entityInfo = existing;
            }
        }
        return entityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends MongoIdentifiableEntity> List<T> convertCursor(Class<T> type, DBCursor cursor, MongoStoreInvocationContext context) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            for (DBObject dbObject : cursor) {
                T entity = this.convertDBObjectToEntity(type, dbObject, context);
                result.add(entity);
            }
        }
        finally {
            cursor.close();
        }
        return result;
    }

    protected <T extends MongoIdentifiableEntity> T convertDBObjectToEntity(Class<T> type, DBObject dbObject, MongoStoreInvocationContext context) {
        String id = dbObject.get("_id").toString();
        Object object = context.getLoadedEntity(type, id);
        if (object == null) {
            MapperContext<DBObject, T> mapperContext = new MapperContext<DBObject, T>(dbObject, type, null);
            object = (MongoIdentifiableEntity)this.mapperRegistry.convertDBObjectToApplicationObject(mapperContext);
            context.addLoadedEntity((MongoIdentifiableEntity)object);
        }
        return object;
    }

    protected DBCollection getDBCollectionForType(Class<?> type) {
        EntityInfo entityInfo = this.getEntityInfo(type);
        String dbCollectionName = entityInfo.getDbCollectionName();
        return dbCollectionName == null ? null : this.database.getCollection(dbCollectionName);
    }
}

