/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.types;

import com.mongodb.BasicDBObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;
import org.keycloak.connections.mongo.api.types.MapperRegistry;

public class BasicDBObjectToMapMapper
implements Mapper<BasicDBObject, Map> {
    private final MapperRegistry mapperRegistry;

    public BasicDBObjectToMapMapper(MapperRegistry mapperRegistry) {
        this.mapperRegistry = mapperRegistry;
    }

    @Override
    public Map convertObject(MapperContext<BasicDBObject, Map> context) {
        BasicDBObject dbObjectToConvert = context.getObjectToConvert();
        Type expectedElementValueType = context.getGenericTypes().get(1);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : dbObjectToConvert.entrySet()) {
            String key = (String)entry.getKey();
            Object dbValue = entry.getValue();
            if (dbValue instanceof Double && expectedElementValueType == Integer.class) {
                dbValue = ((Double)dbValue).intValue();
            }
            MapperContext<Object, Object> newContext = this.getMapperContext(dbValue, expectedElementValueType);
            Object value = this.mapperRegistry.convertDBObjectToApplicationObject(newContext);
            if (key.contains("###")) {
                key = key.replaceAll("###", ".");
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Class<? extends BasicDBObject> getTypeOfObjectToConvert() {
        return BasicDBObject.class;
    }

    @Override
    public Class<Map> getExpectedReturnType() {
        return Map.class;
    }

    private MapperContext<Object, Object> getMapperContext(Object dbValue, Type expectedElementValueType) {
        if (expectedElementValueType instanceof Class) {
            Class clazz = (Class)expectedElementValueType;
            return new MapperContext<Object, Object>(dbValue, clazz, null);
        }
        if (expectedElementValueType instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)expectedElementValueType;
            Class expectedClazz = (Class)parameterized.getRawType();
            Type[] generics = parameterized.getActualTypeArguments();
            return new MapperContext<Object, Object>(dbValue, expectedClazz, Arrays.asList(generics));
        }
        throw new IllegalArgumentException("Unexpected type: '" + expectedElementValueType + "' for converting " + dbValue);
    }
}

