/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

public class UserFederationSyncResult {
    private int added;
    private int updated;
    private int removed;
    private int failed;

    public int getAdded() {
        return this.added;
    }

    public void setAdded(int added) {
        this.added = added;
    }

    public int getUpdated() {
        return this.updated;
    }

    public void setUpdated(int updated) {
        this.updated = updated;
    }

    public int getRemoved() {
        return this.removed;
    }

    public void setRemoved(int removed) {
        this.removed = removed;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public void increaseAdded() {
        ++this.added;
    }

    public void increaseUpdated() {
        ++this.updated;
    }

    public void increaseRemoved() {
        ++this.removed;
    }

    public void increaseFailed() {
        ++this.failed;
    }

    public void add(UserFederationSyncResult other) {
        this.added += other.added;
        this.updated += other.updated;
        this.removed += other.removed;
        this.failed += other.failed;
    }

    public String getStatus() {
        String status = String.format("%d imported users, %d updated users, %d removed users", this.added, this.updated, this.removed);
        if (this.failed != 0) {
            status = status + String.format(", %d users failed sync! See server log for more details", this.failed);
        }
        return status;
    }

    public String toString() {
        return String.format("UserFederationSyncResult [ %s ]", this.getStatus());
    }

    public static UserFederationSyncResult empty() {
        return new UserFederationSyncResult();
    }
}

