/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.query.internal;

import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.Sort;
import org.keycloak.federation.ldap.idm.query.internal.BetweenCondition;
import org.keycloak.federation.ldap.idm.query.internal.EqualCondition;
import org.keycloak.federation.ldap.idm.query.internal.GreaterThanCondition;
import org.keycloak.federation.ldap.idm.query.internal.InCondition;
import org.keycloak.federation.ldap.idm.query.internal.LessThanCondition;
import org.keycloak.federation.ldap.idm.query.internal.LikeCondition;
import org.keycloak.federation.ldap.idm.query.internal.OrCondition;
import org.keycloak.models.ModelException;

public class LDAPQueryConditionsBuilder {
    public Condition like(QueryParameter parameter, String pattern) {
        return new LikeCondition(parameter, pattern);
    }

    public Condition equal(QueryParameter parameter, Object value) {
        return new EqualCondition(parameter, value);
    }

    public Condition greaterThan(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new GreaterThanCondition(parameter, (Comparable)x, false);
    }

    public Condition greaterThanOrEqualTo(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new GreaterThanCondition(parameter, (Comparable)x, true);
    }

    public Condition lessThan(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new LessThanCondition(parameter, (Comparable)x, false);
    }

    public Condition lessThanOrEqualTo(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new LessThanCondition(parameter, (Comparable)x, true);
    }

    public Condition between(QueryParameter parameter, Object x, Object y) {
        this.throwExceptionIfNotComparable(x);
        this.throwExceptionIfNotComparable(y);
        return new BetweenCondition(parameter, (Comparable)x, (Comparable)y);
    }

    public Condition orCondition(Condition ... conditions) {
        if (conditions == null || conditions.length == 0) {
            throw new ModelException("At least one condition should be provided to OR query");
        }
        return new OrCondition(conditions);
    }

    public Condition in(QueryParameter parameter, Object ... x) {
        return new InCondition(parameter, x);
    }

    public Sort asc(QueryParameter parameter) {
        return new Sort(parameter, true);
    }

    public Sort desc(QueryParameter parameter) {
        return new Sort(parameter, false);
    }

    private void throwExceptionIfNotComparable(Object x) {
        if (!Comparable.class.isInstance(x)) {
            throw new ModelException("Query parameter value [" + x + "] must be " + Comparable.class + ".");
        }
    }
}

