/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.compat;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class SimpleUserSessionInitializer {
    private final KeycloakSessionFactory sessionFactory;
    private final SessionLoader sessionLoader;
    private final int sessionsPerSegment;

    public SimpleUserSessionInitializer(KeycloakSessionFactory sessionFactory, SessionLoader sessionLoader, int sessionsPerSegment) {
        this.sessionFactory = sessionFactory;
        this.sessionLoader = sessionLoader;
        this.sessionsPerSegment = sessionsPerSegment;
    }

    public void loadPersistentSessions() {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                SimpleUserSessionInitializer.this.sessionLoader.init(session);
            }
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                int count = SimpleUserSessionInitializer.this.sessionLoader.getSessionsCount(session);
                for (int i = 0; i < count; i += SimpleUserSessionInitializer.this.sessionsPerSegment) {
                    SimpleUserSessionInitializer.this.sessionLoader.loadSessions(session, i, SimpleUserSessionInitializer.this.sessionsPerSegment);
                }
            }
        });
    }
}

