/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class InitializerState
extends SessionEntity {
    private static final Logger log = Logger.getLogger(InitializerState.class);
    private int sessionsCount;
    private List<Boolean> segments = new ArrayList<Boolean>();
    private int lowestUnfinishedSegment = 0;

    public void init(int sessionsCount, int sessionsPerSegment) {
        this.sessionsCount = sessionsCount;
        int segmentsCount = sessionsCount / sessionsPerSegment;
        if (sessionsPerSegment * segmentsCount < sessionsCount) {
            ++segmentsCount;
        }
        log.debugf("sessionsCount: %d, sessionsPerSegment: %d, segmentsCount: %d", (Object)sessionsCount, (Object)sessionsPerSegment, (Object)segmentsCount);
        for (int i = 0; i < segmentsCount; ++i) {
            this.segments.add(false);
        }
        this.updateLowestUnfinishedSegment();
    }

    public boolean isFinished() {
        return this.lowestUnfinishedSegment == -1;
    }

    public List<Integer> getUnfinishedSegments(int segmentCount) {
        boolean remaining;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int next = this.lowestUnfinishedSegment;
        boolean bl = remaining = this.lowestUnfinishedSegment != -1;
        while (remaining && result.size() < segmentCount) {
            if ((next = this.getNextUnfinishedSegmentFromIndex(next)) == -1) {
                remaining = false;
                continue;
            }
            result.add(next);
            ++next;
        }
        return result;
    }

    public void markSegmentFinished(int index) {
        this.segments.set(index, true);
        this.updateLowestUnfinishedSegment();
    }

    private void updateLowestUnfinishedSegment() {
        this.lowestUnfinishedSegment = this.getNextUnfinishedSegmentFromIndex(this.lowestUnfinishedSegment);
    }

    private int getNextUnfinishedSegmentFromIndex(int index) {
        int segmentsSize = this.segments.size();
        for (int i = index; i < segmentsSize; ++i) {
            Boolean entry = this.segments.get(i);
            if (entry.booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public String printState() {
        int finished = 0;
        int nonFinished = 0;
        int size = this.segments.size();
        for (int i = 0; i < size; ++i) {
            Boolean done = this.segments.get(i);
            if (done.booleanValue()) {
                ++finished;
                continue;
            }
            ++nonFinished;
        }
        StringBuilder strBuilder = new StringBuilder("sessionsCount: " + this.sessionsCount).append(", finished segments count: " + finished).append(", non-finished segments count: " + nonFinished);
        return strBuilder.toString();
    }
}

