/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.logging.Logger;
import org.keycloak.connections.truststore.HostnameVerificationPolicy;
import org.keycloak.connections.truststore.JSSETruststoreConfigurator;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class DefaultEmailSenderProvider
implements EmailSenderProvider {
    private static final Logger log = Logger.getLogger(DefaultEmailSenderProvider.class);
    private final KeycloakSession session;

    public DefaultEmailSenderProvider(KeycloakSession session) {
        this.session = session;
    }

    public void send(RealmModel realm, UserModel user, String subject, String textBody, String htmlBody) throws EmailException {
        try {
            String address = user.getEmail();
            Map config = realm.getSmtpConfig();
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", (String)config.get("host"));
            boolean auth = "true".equals(config.get("auth"));
            boolean ssl = "true".equals(config.get("ssl"));
            boolean starttls = "true".equals(config.get("starttls"));
            if (config.containsKey("port")) {
                props.setProperty("mail.smtp.port", (String)config.get("port"));
            }
            if (auth) {
                props.setProperty("mail.smtp.auth", "true");
            }
            if (ssl) {
                props.setProperty("mail.smtp.ssl.enable", "true");
            }
            if (starttls) {
                props.setProperty("mail.smtp.starttls.enable", "true");
            }
            if (ssl || starttls) {
                this.setupTruststore(props);
            }
            props.setProperty("mail.smtp.timeout", "10000");
            props.setProperty("mail.smtp.connectiontimeout", "10000");
            String from = (String)config.get("from");
            Session session = Session.getInstance((Properties)props);
            MimeMultipart multipart = new MimeMultipart("alternative");
            if (textBody != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(textBody, "UTF-8");
                multipart.addBodyPart((BodyPart)textPart);
            }
            if (htmlBody != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
                multipart.addBodyPart((BodyPart)htmlPart);
            }
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setHeader("To", address);
            msg.setSubject(subject);
            msg.setContent((Multipart)multipart);
            msg.saveChanges();
            msg.setSentDate(new Date());
            Transport transport = session.getTransport("smtp");
            if (auth) {
                transport.connect((String)config.get("user"), (String)config.get("password"));
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, (Address[])new InternetAddress[]{new InternetAddress(address)});
        }
        catch (Exception e) {
            log.error((Object)"Failed to send email", (Throwable)e);
            throw new EmailException((Throwable)e);
        }
    }

    private void setupTruststore(Properties props) throws NoSuchAlgorithmException, KeyManagementException {
        JSSETruststoreConfigurator configurator = new JSSETruststoreConfigurator(this.session);
        props.put("mail.smtp.ssl.socketFactory", configurator.getSSLSocketFactory());
        if (configurator.getProvider().getPolicy() == HostnameVerificationPolicy.ANY) {
            props.setProperty("mail.smtp.ssl.trust", "*");
        }
    }

    public void close() {
    }
}

