/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.KeycloakTransactionManager;

public class DefaultKeycloakTransactionManager
implements KeycloakTransactionManager {
    public static final Logger logger = Logger.getLogger(DefaultKeycloakTransactionManager.class);
    private List<KeycloakTransaction> transactions = new LinkedList<KeycloakTransaction>();
    private List<KeycloakTransaction> afterCompletion = new LinkedList<KeycloakTransaction>();
    private boolean active;
    private boolean rollback;

    public void enlist(KeycloakTransaction transaction) {
        if (this.active && !transaction.isActive()) {
            transaction.begin();
        }
        this.transactions.add(transaction);
    }

    public void enlistAfterCompletion(KeycloakTransaction transaction) {
        if (this.active && !transaction.isActive()) {
            transaction.begin();
        }
        this.afterCompletion.add(transaction);
    }

    public void begin() {
        if (this.active) {
            throw new IllegalStateException("Transaction already active");
        }
        for (KeycloakTransaction tx : this.transactions) {
            tx.begin();
        }
        this.active = true;
    }

    public void commit() {
        RuntimeException exception = null;
        for (KeycloakTransaction tx : this.transactions) {
            try {
                tx.commit();
            }
            catch (RuntimeException e) {
                exception = exception == null ? e : exception;
            }
        }
        if (exception == null) {
            for (KeycloakTransaction tx : this.afterCompletion) {
                try {
                    tx.commit();
                }
                catch (RuntimeException e) {
                    exception = exception == null ? e : exception;
                }
            }
        } else {
            for (KeycloakTransaction tx : this.afterCompletion) {
                try {
                    tx.rollback();
                }
                catch (RuntimeException e) {
                    logger.error((Object)"Exception during rollback", (Throwable)e);
                }
            }
        }
        this.active = false;
        if (exception != null) {
            throw exception;
        }
    }

    public void rollback() {
        RuntimeException exception = null;
        for (KeycloakTransaction tx : this.transactions) {
            try {
                tx.rollback();
            }
            catch (RuntimeException e) {
                exception = exception != null ? e : exception;
            }
        }
        for (KeycloakTransaction tx : this.afterCompletion) {
            try {
                tx.rollback();
            }
            catch (RuntimeException e) {
                exception = exception != null ? e : exception;
            }
        }
        this.active = false;
        if (exception != null) {
            throw exception;
        }
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        if (this.rollback) {
            return true;
        }
        for (KeycloakTransaction tx : this.transactions) {
            if (!tx.getRollbackOnly()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }
}

