/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.keycloak.TokenIdGenerator;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.Time;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.util.ResolveRelative;

public class ResourceAdminManager {
    protected static Logger logger = Logger.getLogger(ResourceAdminManager.class);
    private static final String CLIENT_SESSION_HOST_PROPERTY = "${application.session.host}";
    private KeycloakSession session;

    public ResourceAdminManager(KeycloakSession session) {
        this.session = session;
    }

    public static String resolveUri(URI requestUri, String rootUrl, String uri) {
        String absoluteURI = ResolveRelative.resolveRelativeUri(requestUri, rootUrl, uri);
        return StringPropertyReplacer.replaceProperties((String)absoluteURI);
    }

    public static String getManagementUrl(URI requestUri, ClientModel client) {
        String mgmtUrl = client.getManagementUrl();
        if (mgmtUrl == null || mgmtUrl.equals("")) {
            return null;
        }
        String absoluteURI = ResolveRelative.resolveRelativeUri(requestUri, client.getRootUrl(), mgmtUrl);
        return StringPropertyReplacer.replaceProperties((String)absoluteURI);
    }

    private List<String> getAllManagementUrls(URI requestUri, ClientModel client) {
        String baseMgmtUrl = ResourceAdminManager.getManagementUrl(requestUri, client);
        if (baseMgmtUrl == null) {
            return Collections.emptyList();
        }
        Set<String> registeredNodesHosts = new ClientManager().validateRegisteredNodes(client);
        if (registeredNodesHosts.isEmpty()) {
            return Arrays.asList(baseMgmtUrl);
        }
        LinkedList<String> result = new LinkedList<String>();
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)baseMgmtUrl);
        for (String nodeHost : registeredNodesHosts) {
            String currentNodeUri = uriBuilder.clone().host(nodeHost).build(new Object[0]).toString();
            result.add(currentNodeUri);
        }
        return result;
    }

    public void logoutUser(URI requestUri, RealmModel realm, UserModel user, KeycloakSession keycloakSession) {
        List userSessions = keycloakSession.sessions().getUserSessions(realm, user);
        this.logoutUserSessions(requestUri, realm, userSessions);
    }

    protected void logoutUserSessions(URI requestUri, RealmModel realm, List<UserSessionModel> userSessions) {
        MultivaluedHashMap clientSessions = new MultivaluedHashMap();
        for (UserSessionModel userSession : userSessions) {
            this.putClientSessions((MultivaluedHashMap<ClientModel, ClientSessionModel>)clientSessions, userSession);
        }
        logger.debugv("logging out {0} resources ", (Object)clientSessions.size());
        for (Map.Entry entry : clientSessions.entrySet()) {
            this.logoutClientSessions(requestUri, realm, (ClientModel)entry.getKey(), (List)entry.getValue());
        }
    }

    private void putClientSessions(MultivaluedHashMap<ClientModel, ClientSessionModel> clientSessions, UserSessionModel userSession) {
        for (ClientSessionModel clientSession : userSession.getClientSessions()) {
            ClientModel client = clientSession.getClient();
            clientSessions.add((Object)client, (Object)clientSession);
        }
    }

    public void logoutUserFromClient(URI requestUri, RealmModel realm, ClientModel resource, UserModel user) {
        List userSessions = this.session.sessions().getUserSessions(realm, user);
        List ourAppClientSessions = null;
        if (userSessions != null) {
            MultivaluedHashMap clientSessions = new MultivaluedHashMap();
            for (UserSessionModel userSession : userSessions) {
                this.putClientSessions((MultivaluedHashMap<ClientModel, ClientSessionModel>)clientSessions, userSession);
            }
            ourAppClientSessions = (List)clientSessions.get((Object)resource);
        }
        this.logoutClientSessions(requestUri, realm, resource, ourAppClientSessions);
    }

    public boolean logoutClientSession(URI requestUri, RealmModel realm, ClientModel resource, ClientSessionModel clientSession) {
        return this.logoutClientSessions(requestUri, realm, resource, Arrays.asList(clientSession));
    }

    protected boolean logoutClientSessions(URI requestUri, RealmModel realm, ClientModel resource, List<ClientSessionModel> clientSessions) {
        String managementUrl = ResourceAdminManager.getManagementUrl(requestUri, resource);
        if (managementUrl != null) {
            String host;
            MultivaluedHashMap adapterSessionIds = null;
            LinkedList<String> userSessions = new LinkedList<String>();
            if (clientSessions != null && clientSessions.size() > 0) {
                adapterSessionIds = new MultivaluedHashMap();
                for (ClientSessionModel clientSession : clientSessions) {
                    String adapterSessionId = clientSession.getNote("client_session_state");
                    if (adapterSessionId != null) {
                        host = clientSession.getNote("client_session_host");
                        adapterSessionIds.add((Object)host, (Object)adapterSessionId);
                    }
                    if (clientSession.getUserSession() == null) continue;
                    userSessions.add(clientSession.getUserSession().getId());
                }
            }
            if (adapterSessionIds == null || adapterSessionIds.isEmpty()) {
                logger.debugv("Can't logout {0}: no logged adapter sessions", (Object)resource.getClientId());
                return false;
            }
            if (managementUrl.contains(CLIENT_SESSION_HOST_PROPERTY)) {
                boolean allPassed = true;
                for (Map.Entry entry : adapterSessionIds.entrySet()) {
                    String currentHostMgmtUrl;
                    host = (String)entry.getKey();
                    List sessionIds = (List)entry.getValue();
                    allPassed = this.sendLogoutRequest(realm, resource, sessionIds, userSessions, 0, currentHostMgmtUrl = managementUrl.replace(CLIENT_SESSION_HOST_PROPERTY, host)) && allPassed;
                }
                return allPassed;
            }
            ArrayList<String> allSessionIds = new ArrayList<String>();
            for (List currentIds : adapterSessionIds.values()) {
                allSessionIds.addAll(currentIds);
            }
            return this.sendLogoutRequest(realm, resource, allSessionIds, userSessions, 0, managementUrl);
        }
        logger.debugv("Can't logout {0}: no management url", (Object)resource.getClientId());
        return false;
    }

    public GlobalRequestResult logoutAll(URI requestUri, RealmModel realm) {
        realm.setNotBefore(Time.currentTime());
        List resources = realm.getClients();
        logger.debugv("logging out {0} resources ", (Object)resources.size());
        GlobalRequestResult finalResult = new GlobalRequestResult();
        for (ClientModel resource : resources) {
            GlobalRequestResult currentResult = this.logoutClient(requestUri, realm, resource, realm.getNotBefore());
            finalResult.addAll(currentResult);
        }
        return finalResult;
    }

    public GlobalRequestResult logoutClient(URI requestUri, RealmModel realm, ClientModel resource) {
        resource.setNotBefore(Time.currentTime());
        return this.logoutClient(requestUri, realm, resource, resource.getNotBefore());
    }

    protected GlobalRequestResult logoutClient(URI requestUri, RealmModel realm, ClientModel resource, int notBefore) {
        List<String> mgmtUrls = this.getAllManagementUrls(requestUri, resource);
        if (mgmtUrls.isEmpty()) {
            logger.debug((Object)("No management URL or no registered cluster nodes for the client " + resource.getClientId()));
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send logoutClient for URLs: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendLogoutRequest(realm, resource, null, null, notBefore, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    protected boolean sendLogoutRequest(RealmModel realm, ClientModel resource, List<String> adapterSessionIds, List<String> userSessions, int notBefore, String managementUrl) {
        LogoutAction adminAction = new LogoutAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getClientId(), adapterSessionIds, notBefore, userSessions);
        String token = new TokenManager().encodeToken(realm, adminAction);
        if (logger.isDebugEnabled()) {
            logger.debugv("logout resource {0} url: {1} sessionIds: " + adapterSessionIds, (Object)resource.getClientId(), (Object)managementUrl);
        }
        URI target = UriBuilder.fromUri((String)managementUrl).path("k_logout").build(new Object[0]);
        try {
            int status = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).postText(target.toString(), token);
            boolean success = status == 204 || status == 200;
            logger.debugf("logout success for %s: %s", (Object)managementUrl, (Object)success);
            return success;
        }
        catch (IOException e) {
            logger.warn((Object)("Logout for client '" + resource.getClientId() + "' failed"), (Throwable)e);
            return false;
        }
    }

    public GlobalRequestResult pushRealmRevocationPolicy(URI requestUri, RealmModel realm) {
        GlobalRequestResult finalResult = new GlobalRequestResult();
        for (ClientModel client : realm.getClients()) {
            GlobalRequestResult currentResult = this.pushRevocationPolicy(requestUri, realm, client, realm.getNotBefore());
            finalResult.addAll(currentResult);
        }
        return finalResult;
    }

    public GlobalRequestResult pushClientRevocationPolicy(URI requestUri, RealmModel realm, ClientModel client) {
        return this.pushRevocationPolicy(requestUri, realm, client, client.getNotBefore());
    }

    protected GlobalRequestResult pushRevocationPolicy(URI requestUri, RealmModel realm, ClientModel resource, int notBefore) {
        List<String> mgmtUrls = this.getAllManagementUrls(requestUri, resource);
        if (mgmtUrls.isEmpty()) {
            logger.debugf("No management URL or no registered cluster nodes for the client %s", (Object)resource.getClientId());
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending push revocation to URLS: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendPushRevocationPolicyRequest(realm, resource, notBefore, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    protected boolean sendPushRevocationPolicyRequest(RealmModel realm, ClientModel resource, int notBefore, String managementUrl) {
        PushNotBeforeAction adminAction = new PushNotBeforeAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getClientId(), notBefore);
        String token = new TokenManager().encodeToken(realm, adminAction);
        logger.debugv("pushRevocation resource: {0} url: {1}", (Object)resource.getClientId(), (Object)managementUrl);
        URI target = UriBuilder.fromUri((String)managementUrl).path("k_push_not_before").build(new Object[0]);
        try {
            int status = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).postText(target.toString(), token);
            boolean success = status == 204 || status == 200;
            logger.debugf("pushRevocation success for %s: %s", (Object)managementUrl, (Object)success);
            return success;
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to send revocation request", (Throwable)e);
            return false;
        }
    }

    public GlobalRequestResult testNodesAvailability(URI requestUri, RealmModel realm, ClientModel client) {
        List<String> mgmtUrls = this.getAllManagementUrls(requestUri, client);
        if (mgmtUrls.isEmpty()) {
            logger.debug((Object)("No management URL or no registered cluster nodes for the application " + client.getClientId()));
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending test nodes availability: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendTestNodeAvailabilityRequest(realm, client, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    protected boolean sendTestNodeAvailabilityRequest(RealmModel realm, ClientModel client, String managementUrl) {
        TestAvailabilityAction adminAction = new TestAvailabilityAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, client.getClientId());
        String token = new TokenManager().encodeToken(realm, adminAction);
        logger.debugv("testNodes availability resource: {0} url: {1}", (Object)client.getClientId(), (Object)managementUrl);
        URI target = UriBuilder.fromUri((String)managementUrl).path("k_test_available").build(new Object[0]);
        try {
            int status = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).postText(target.toString(), token);
            boolean success = status == 204 || status == 200;
            logger.debugf("testAvailability success for %s: %s", (Object)managementUrl, (Object)success);
            return success;
        }
        catch (IOException e) {
            logger.warn((Object)("Availability test failed for uri '" + managementUrl + "'"), (Throwable)e);
            return false;
        }
    }
}

