/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers.membership.group;

import java.util.Collection;
import java.util.Collections;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.membership.CommonLDAPGroupMapperConfig;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserFederationMapperModel;

public class GroupMapperConfig
extends CommonLDAPGroupMapperConfig {
    public static final String GROUPS_DN = "groups.dn";
    public static final String GROUP_NAME_LDAP_ATTRIBUTE = "group.name.ldap.attribute";
    public static final String GROUP_OBJECT_CLASSES = "group.object.classes";
    public static final String PRESERVE_GROUP_INHERITANCE = "preserve.group.inheritance";
    public static final String GROUPS_LDAP_FILTER = "groups.ldap.filter";
    public static final String MAPPED_GROUP_ATTRIBUTES = "mapped.group.attributes";
    public static final String DROP_NON_EXISTING_GROUPS_DURING_SYNC = "drop.non.existing.groups.during.sync";
    public static final String LOAD_GROUPS_BY_MEMBER_ATTRIBUTE = "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE";
    public static final String GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE = "GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE";
    public static final String LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY = "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY";

    public GroupMapperConfig(UserFederationMapperModel mapperModel) {
        super(mapperModel);
    }

    public String getGroupsDn() {
        String groupsDn = (String)this.mapperModel.getConfig().get(GROUPS_DN);
        if (groupsDn == null) {
            throw new ModelException("Groups DN is null! Check your configuration");
        }
        return groupsDn;
    }

    @Override
    public String getLDAPGroupsDn() {
        return this.getGroupsDn();
    }

    public String getGroupNameLdapAttribute() {
        String rolesRdnAttr = (String)this.mapperModel.getConfig().get(GROUP_NAME_LDAP_ATTRIBUTE);
        return rolesRdnAttr != null ? rolesRdnAttr : "cn";
    }

    @Override
    public String getLDAPGroupNameLdapAttribute() {
        return this.getGroupNameLdapAttribute();
    }

    public boolean isPreserveGroupsInheritance() {
        return AbstractLDAPFederationMapper.parseBooleanParameter(this.mapperModel, PRESERVE_GROUP_INHERITANCE);
    }

    @Override
    public String getMembershipLdapAttribute() {
        String membershipAttrName = (String)this.mapperModel.getConfig().get("membership.ldap.attribute");
        return membershipAttrName != null ? membershipAttrName : "member";
    }

    public Collection<String> getGroupObjectClasses(LDAPFederationProvider ldapProvider) {
        String objectClasses = (String)this.mapperModel.getConfig().get(GROUP_OBJECT_CLASSES);
        if (objectClasses == null) {
            objectClasses = ldapProvider.getLdapIdentityStore().getConfig().isActiveDirectory() ? "group" : "groupOfNames";
        }
        return this.getConfigValues(objectClasses);
    }

    public Collection<String> getGroupAttributes() {
        String groupAttrs = (String)this.mapperModel.getConfig().get(MAPPED_GROUP_ATTRIBUTES);
        return groupAttrs == null ? Collections.emptySet() : this.getConfigValues(groupAttrs);
    }

    public String getCustomLdapFilter() {
        return (String)this.mapperModel.getConfig().get(GROUPS_LDAP_FILTER);
    }

    public boolean isDropNonExistingGroupsDuringSync() {
        return AbstractLDAPFederationMapper.parseBooleanParameter(this.mapperModel, DROP_NON_EXISTING_GROUPS_DURING_SYNC);
    }

    public String getUserGroupsRetrieveStrategy() {
        String strategyString = (String)this.mapperModel.getConfig().get("user.roles.retrieve.strategy");
        return strategyString != null ? strategyString : LOAD_GROUPS_BY_MEMBER_ATTRIBUTE;
    }
}

