/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core.supplier;

import junit.framework.Assert;
import liquibase.change.Change;
import liquibase.change.core.AlterSequenceChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.exception.DatabaseException;
import liquibase.sdk.supplier.change.AbstractChangeSupplier;
import liquibase.structure.core.Sequence;

public class AlterSequenceChangeSupplier
extends AbstractChangeSupplier<AlterSequenceChange> {
    public AlterSequenceChangeSupplier() {
        super(AlterSequenceChange.class);
    }

    @Override
    public Change[] prepareDatabase(AlterSequenceChange change) throws DatabaseException {
        CreateSequenceChange createSequenceChange = new CreateSequenceChange();
        createSequenceChange.setCatalogName(change.getCatalogName());
        createSequenceChange.setSchemaName(change.getSchemaName());
        createSequenceChange.setSequenceName(change.getSequenceName());
        return new Change[]{createSequenceChange};
    }

    @Override
    public void checkDiffResult(DiffResult diffResult, AlterSequenceChange change) {
        ObjectDifferences diff;
        if (change.getMinValue() != null) {
            diff = diffResult.getChangedObject(new Sequence(change.getCatalogName(), change.getSchemaName(), change.getSequenceName()));
            Assert.assertEquals((Object)change.getMinValue(), (Object)diff.getDifference("minValue").getComparedValue());
        }
        if (change.getMaxValue() != null) {
            diff = diffResult.getChangedObject(new Sequence(change.getCatalogName(), change.getSchemaName(), change.getSequenceName()));
            Assert.assertEquals((Object)change.getMaxValue(), (Object)diff.getDifference("maxValue").getComparedValue());
        }
        if (change.getIncrementBy() != null) {
            diff = diffResult.getChangedObject(new Sequence(change.getCatalogName(), change.getSchemaName(), change.getSequenceName()));
            Assert.assertEquals((Object)change.getIncrementBy(), (Object)diff.getDifference("incrementBy").getComparedValue());
        }
        if (change.isOrdered() != null) {
            diff = diffResult.getChangedObject(new Sequence(change.getCatalogName(), change.getSchemaName(), change.getSequenceName()));
            Assert.assertEquals((Object)change.isOrdered(), (Object)diff.getDifference("ordered").getComparedValue());
        }
    }
}

