/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition;

import java.util.ArrayList;
import java.util.List;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.AbstractPrecondition;
import liquibase.precondition.Precondition;
import liquibase.precondition.PreconditionFactory;
import liquibase.resource.ResourceAccessor;

public abstract class PreconditionLogic
extends AbstractPrecondition {
    private List<Precondition> nestedPreconditions = new ArrayList<Precondition>();

    public List<Precondition> getNestedPreconditions() {
        return this.nestedPreconditions;
    }

    public void addNestedPrecondition(Precondition precondition) {
        if (precondition != null) {
            this.nestedPreconditions.add(precondition);
        }
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        super.load(parsedNode, resourceAccessor);
        for (ParsedNode child : parsedNode.getChildren()) {
            this.addNestedPrecondition(this.toPrecondition(child, resourceAccessor));
        }
    }

    protected Precondition toPrecondition(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        Precondition precondition = PreconditionFactory.getInstance().create(node.getName());
        if (precondition == null) {
            return null;
        }
        precondition.load(node, resourceAccessor);
        return precondition;
    }
}

