/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class CompositeResourceAccessor
implements ResourceAccessor {
    private List<ResourceAccessor> resourceAccessors;

    public CompositeResourceAccessor(List<ResourceAccessor> resourceAccessors) {
        this.resourceAccessors = resourceAccessors;
    }

    public CompositeResourceAccessor(ResourceAccessor ... resourceAccessors) {
        this.resourceAccessors = Arrays.asList(resourceAccessors);
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        for (ResourceAccessor accessor : this.resourceAccessors) {
            Set<InputStream> returnSet = accessor.getResourcesAsStream(path);
            if (returnSet == null || returnSet.size() <= 0) continue;
            return returnSet;
        }
        return null;
    }

    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        HashSet<String> returnSet = new HashSet<String>();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            Set<String> thisSet = accessor.list(relativeTo, path, includeFiles, includeDirectories, recursive);
            if (thisSet == null) continue;
            returnSet.addAll(thisSet);
        }
        if (returnSet.size() > 0) {
            return returnSet;
        }
        return null;
    }

    @Override
    public ClassLoader toClassLoader() {
        ClassLoader[] loaders = new ClassLoader[this.resourceAccessors.size()];
        int i = 0;
        for (ResourceAccessor fo : this.resourceAccessors) {
            loaders[i++] = fo.toClassLoader();
        }
        return new CompositeClassLoader(loaders);
    }

    public String toString() {
        ArrayList<String> openerStrings = new ArrayList<String>();
        for (ResourceAccessor opener : this.resourceAccessors) {
            openerStrings.add(opener.toString());
        }
        return this.getClass().getName() + "(" + StringUtils.join(openerStrings, ",") + ")";
    }

    private static class CompositeClassLoader
    extends ClassLoader {
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        public CompositeClassLoader(ClassLoader ... classLoaders) {
            this.classLoaders.addAll(Arrays.asList(classLoaders));
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Iterator<ClassLoader> i$ = this.classLoaders.iterator();
            while (i$.hasNext()) {
                ClassLoader classLoader1;
                ClassLoader classLoader = classLoader1 = i$.next();
                try {
                    Class<?> classe = classLoader.loadClass(name);
                    if (resolve) {
                        this.resolveClass(classe);
                    }
                    return classe;
                }
                catch (ClassNotFoundException notFound) {
                }
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                Class<?> classe = contextClassLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(classe);
                }
                return classe;
            }
            throw new ClassNotFoundException(name);
        }
    }
}

