/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.mongo;

import com.mongodb.DBCollection;
import com.mongodb.WriteConcern;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.mongo.MongoConnectionProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventStoreProviderFactory;
import org.keycloak.events.mongo.MongoEventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class MongoEventStoreProviderFactory
implements EventStoreProviderFactory {
    protected static final Logger logger = Logger.getLogger(MongoEventStoreProviderFactory.class);
    public static final String ID = "mongo";

    public EventStoreProvider create(KeycloakSession session) {
        MongoConnectionProvider connection = (MongoConnectionProvider)session.getProvider(MongoConnectionProvider.class);
        DBCollection collection = connection.getDB().getCollection("events");
        DBCollection adminCollection = connection.getDB().getCollection("adminEvents");
        collection.setWriteConcern(WriteConcern.UNACKNOWLEDGED);
        adminCollection.setWriteConcern(WriteConcern.UNACKNOWLEDGED);
        return new MongoEventStoreProvider(collection, adminCollection);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

