/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderCreationEventImpl;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.ClientTemplateAdapter;
import org.keycloak.models.jpa.GroupAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.AuthenticationExecutionEntity;
import org.keycloak.models.jpa.entities.AuthenticationFlowEntity;
import org.keycloak.models.jpa.entities.AuthenticatorConfigEntity;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientTemplateEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.IdentityProviderEntity;
import org.keycloak.models.jpa.entities.IdentityProviderMapperEntity;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RequiredActionProviderEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.UserFederationMapperEntity;
import org.keycloak.models.jpa.entities.UserFederationProviderEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class RealmAdapter
implements RealmModel {
    protected RealmEntity realm;
    protected EntityManager em;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient X509Certificate certificate;
    protected volatile transient Key codeSecretKey;
    protected KeycloakSession session;
    private PasswordPolicy passwordPolicy;
    private OTPPolicy otpPolicy;
    private static final String BROWSER_HEADER_PREFIX = "_browser_header.";

    public RealmAdapter(KeycloakSession session, EntityManager em, RealmEntity realm) {
        this.session = session;
        this.em = em;
        this.realm = realm;
    }

    public RealmEntity getEntity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public String getDisplayName() {
        return this.getAttribute("displayName");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("displayName", displayName);
    }

    public String getDisplayNameHtml() {
        return this.getAttribute("displayNameHtml");
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.setAttribute("displayNameHtml", displayNameHtml);
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public SslRequired getSslRequired() {
        return this.realm.getSslRequired() != null ? SslRequired.valueOf((String)this.realm.getSslRequired()) : null;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
        this.em.flush();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.em.flush();
    }

    public void setAttribute(String name, String value) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        RealmAttributeEntity attr = new RealmAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setRealm(this.realm);
        this.em.persist((Object)attr);
        this.realm.getAttributes().add(attr);
    }

    public void setAttribute(String name, Boolean value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Integer value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Long value) {
        this.setAttribute(name, value.toString());
    }

    public void removeAttribute(String name) {
        Iterator<RealmAttributeEntity> it = this.realm.getAttributes().iterator();
        while (it.hasNext()) {
            RealmAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Long.parseLong(v) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public boolean isBruteForceProtected() {
        return this.getAttribute("bruteForceProtected", false);
    }

    public void setBruteForceProtected(boolean value) {
        this.setAttribute("bruteForceProtected", value);
    }

    public int getMaxFailureWaitSeconds() {
        return this.getAttribute("maxFailureWaitSeconds", 0);
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.setAttribute("maxFailureWaitSeconds", val);
    }

    public int getWaitIncrementSeconds() {
        return this.getAttribute("waitIncrementSeconds", 0);
    }

    public void setWaitIncrementSeconds(int val) {
        this.setAttribute("waitIncrementSeconds", val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.getAttribute("quickLoginCheckMilliSeconds", 0L);
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.setAttribute("quickLoginCheckMilliSeconds", val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.getAttribute("minimumQuickLoginWaitSeconds", 0);
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.setAttribute("minimumQuickLoginWaitSeconds", val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.getAttribute("maxDeltaTimeSeconds", 0);
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.setAttribute("maxDeltaTimeSeconds", val);
    }

    public int getFailureFactor() {
        return this.getAttribute("failureFactor", 0);
    }

    public void setFailureFactor(int failureFactor) {
        this.setAttribute("failureFactor", failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.realm.setEditUsernameAllowed(editUsernameAllowed);
        this.em.flush();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public boolean isRevokeRefreshToken() {
        return this.realm.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.realm.setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.realm.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.realm.setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        return this.realm.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.realm.setOfflineSessionIdleTimeout(seconds);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
        this.em.flush();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.em.flush();
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certificatePem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certificatePem);
    }

    public String getCertificatePem() {
        return this.realm.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.realm.setCertificatePem(certificate);
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.em.flush();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.realm.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.realm.setCodeSecret(codeSecret);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setRealm(this.realm);
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entities.add(roleEntity);
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (Iterator<RoleEntity> iterator : defaultRoles) {
            if (already.contains(iterator)) continue;
            this.addDefaultRole((String)((Object)iterator));
        }
        this.em.flush();
    }

    public List<GroupModel> getDefaultGroups() {
        Collection<GroupEntity> entities = this.realm.getDefaultGroups();
        LinkedList<GroupModel> defaultGroups = new LinkedList<GroupModel>();
        for (GroupEntity entity : entities) {
            defaultGroups.add(this.session.realms().getGroupById(entity.getId(), (RealmModel)this));
        }
        return defaultGroups;
    }

    public void addDefaultGroup(GroupModel group) {
        Collection<GroupEntity> entities = this.realm.getDefaultGroups();
        for (GroupEntity entity : entities) {
            if (!entity.getId().equals(group.getId())) continue;
            return;
        }
        GroupEntity groupEntity = GroupAdapter.toEntity(group, this.em);
        this.realm.getDefaultGroups().add(groupEntity);
        this.em.flush();
    }

    public void removeDefaultGroup(GroupModel group) {
        GroupEntity found = null;
        for (GroupEntity defaultGroup : this.realm.getDefaultGroups()) {
            if (!defaultGroup.getId().equals(group.getId())) continue;
            found = defaultGroup;
            break;
        }
        if (found != null) {
            this.realm.getDefaultGroups().remove(found);
            this.em.flush();
        }
    }

    public Map<String, ClientModel> getClientNameMap() {
        HashMap<String, ClientModel> map = new HashMap<String, ClientModel>();
        for (ClientModel app : this.getClients()) {
            map.put(app.getClientId(), app);
        }
        return map;
    }

    public List<ClientModel> getClients() {
        ArrayList<ClientModel> list = new ArrayList<ClientModel>();
        if (this.realm.getClients() == null) {
            return list;
        }
        for (ClientEntity entity : this.realm.getClients()) {
            list.add(new ClientAdapter(this, this.em, this.session, entity));
        }
        return list;
    }

    public ClientModel addClient(String name) {
        return this.addClient(KeycloakModelUtils.generateId(), name);
    }

    public ClientModel addClient(String id, String clientId) {
        ClientEntity entity = new ClientEntity();
        entity.setId(id);
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        entity.setRealm(this.realm);
        this.realm.getClients().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        final ClientAdapter resource = new ClientAdapter(this, this.em, this.session, entity);
        this.em.flush();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientCreationEvent(){

            public ClientModel getCreatedClient() {
                return resource;
            }
        });
        return resource;
    }

    public boolean removeClient(String id) {
        if (id == null) {
            return false;
        }
        ClientModel client = this.getClientById(id);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove((RealmModel)this, client);
        for (RoleModel role : client.getRoles()) {
            client.removeRole(role);
        }
        ClientEntity clientEntity = null;
        Iterator<ClientEntity> it = this.realm.getClients().iterator();
        while (it.hasNext()) {
            ClientEntity ae = it.next();
            if (!ae.getId().equals(id)) continue;
            clientEntity = ae;
            it.remove();
            break;
        }
        for (ClientEntity a : this.realm.getClients()) {
            if (!a.getId().equals(id)) continue;
            clientEntity = a;
        }
        if (client == null) {
            return false;
        }
        this.em.remove((Object)clientEntity);
        this.em.createNamedQuery("deleteScopeMappingByClient").setParameter("client", (Object)clientEntity).executeUpdate();
        this.em.flush();
        return true;
    }

    public ClientModel getClientById(String id) {
        return this.session.realms().getClientById(id, (RealmModel)this);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.getClientNameMap().get(clientId);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        Map<String, String> attributes = this.getAttributes();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!entry.getKey().startsWith(BROWSER_HEADER_PREFIX)) continue;
            headers.put(entry.getKey().substring(BROWSER_HEADER_PREFIX.length()), entry.getValue());
        }
        return headers;
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.setAttribute(BROWSER_HEADER_PREFIX + entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List<UserFederationProviderEntity> entities = this.realm.getUserFederationProviders();
        ArrayList<UserFederationProviderEntity> copy = new ArrayList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        ArrayList<UserFederationProviderModel> result = new ArrayList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return result;
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)displayName, null, this.getUserFederationProviders());
        String id = KeycloakModelUtils.generateId();
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(id);
        entity.setRealm(this.realm);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        entity.setPriority(priority);
        if (displayName == null) {
            displayName = id;
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.em.persist((Object)entity);
        this.realm.getUserFederationProviders().add(entity);
        this.em.flush();
        UserFederationProviderModel providerModel = new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, providerModel));
        return providerModel;
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, provider);
            this.removeFederationMappersForProvider(provider.getId());
            it.remove();
            this.em.remove((Object)entity);
            return;
        }
    }

    private void removeFederationMappersForProvider(String federationProviderId) {
        Set<UserFederationMapperEntity> mappers = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity mapper : mappers) {
            this.realm.getUserFederationMappers().remove(mapper);
            this.em.remove((Object)mapper);
        }
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)model.getDisplayName(), (UserFederationProviderModel)model, this.getUserFederationProviders());
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            entity.setProviderName(model.getProviderName());
            entity.setPriority(model.getPriority());
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            break;
        }
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        Object displayName;
        for (UserFederationProviderModel currentProvider : providers) {
            KeycloakModelUtils.ensureUniqueDisplayName((String)currentProvider.getDisplayName(), (UserFederationProviderModel)currentProvider, providers);
        }
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            boolean found = false;
            for (UserFederationProviderModel model : providers) {
                if (!entity.getId().equals(model.getId())) continue;
                entity.setConfig(model.getConfig());
                entity.setPriority(model.getPriority());
                entity.setProviderName(model.getProviderName());
                displayName = model.getDisplayName();
                if (displayName != null) {
                    entity.setDisplayName((String)displayName);
                }
                entity.setFullSyncPeriod(model.getFullSyncPeriod());
                entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
                entity.setLastSync(model.getLastSync());
                found = true;
                break;
            }
            if (found) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            this.removeFederationMappersForProvider(entity.getId());
            it.remove();
            this.em.remove((Object)entity);
        }
        LinkedList<UserFederationProviderModel> add = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderModel model : providers) {
            boolean found = false;
            for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
                if (!entity.getId().equals(model.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            add.add(model);
        }
        for (UserFederationProviderModel model : add) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                String id = KeycloakModelUtils.generateId();
                entity.setId(id);
                model.setId(id);
            }
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            entity.setProviderName(model.getProviderName());
            entity.setPriority(model.getPriority());
            displayName = model.getDisplayName();
            if (displayName == null) {
                displayName = entity.getId();
            }
            entity.setDisplayName((String)displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            this.em.persist((Object)entity);
            this.realm.getUserFederationProviders().add(entity);
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, model));
        }
    }

    protected UserFederationProviderEntity getUserFederationProviderEntityById(String federationProviderId) {
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(federationProviderId)) continue;
            return entity;
        }
        return null;
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleByName", RoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        RoleEntity entity = new RoleEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealm(this.realm);
        entity.setRealmId(this.realm.getId());
        this.realm.getRoles().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        return new RoleAdapter(this, this.em, entity);
    }

    public boolean removeRole(RoleModel role) {
        if (role == null) {
            return false;
        }
        if (!role.getContainer().equals(this)) {
            return false;
        }
        this.session.users().preRemove((RealmModel)this, role);
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        this.realm.getRoles().remove(roleEntity);
        this.realm.getDefaultRoles().remove(roleEntity);
        String compositeRoleTable = JpaUtils.getTableNameForNativeQuery((String)"COMPOSITE_ROLE", (EntityManager)this.em);
        this.em.createNativeQuery("delete from " + compositeRoleTable + " where CHILD_ROLE = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createNamedQuery("deleteScopeMappingByRole").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createNamedQuery("deleteTemplateScopeMappingByRole").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createNamedQuery("deleteGroupRoleMappingsByRole").setParameter("roleId", (Object)roleEntity.getId()).executeUpdate();
        this.em.remove((Object)roleEntity);
        this.em.flush();
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<RoleEntity> roles = this.realm.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity entity : roles) {
            list.add(new RoleAdapter(this, this.em, entity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        return this.session.realms().getRoleById(id, (RealmModel)this);
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        return role.getContainer().removeRole(role);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }

    public OTPPolicy getOTPPolicy() {
        if (this.otpPolicy == null) {
            this.otpPolicy = new OTPPolicy();
            this.otpPolicy.setDigits(this.realm.getOtpPolicyDigits());
            this.otpPolicy.setAlgorithm(this.realm.getOtpPolicyAlgorithm());
            this.otpPolicy.setInitialCounter(this.realm.getOtpPolicyInitialCounter());
            this.otpPolicy.setLookAheadWindow(this.realm.getOtpPolicyLookAheadWindow());
            this.otpPolicy.setType(this.realm.getOtpPolicyType());
            this.otpPolicy.setPeriod(this.realm.getOtpPolicyPeriod());
        }
        return this.otpPolicy;
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.realm.setOtpPolicyAlgorithm(policy.getAlgorithm());
        this.realm.setOtpPolicyDigits(policy.getDigits());
        this.realm.setOtpPolicyInitialCounter(policy.getInitialCounter());
        this.realm.setOtpPolicyLookAheadWindow(policy.getLookAheadWindow());
        this.realm.setOtpPolicyType(policy.getType());
        this.realm.setOtpPolicyPeriod(policy.getPeriod());
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.em.flush();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.em.flush();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.em.flush();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.em.flush();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.em.flush();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.em.flush();
    }

    public Set<String> getEventsListeners() {
        return this.realm.getEventsListeners();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.realm.setEventsListeners(listeners);
        this.em.flush();
    }

    public Set<String> getEnabledEventTypes() {
        return this.realm.getEnabledEventTypes();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.realm.setEnabledEventTypes(enabledEventTypes);
        this.em.flush();
    }

    public boolean isAdminEventsEnabled() {
        return this.realm.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.realm.setAdminEventsEnabled(enabled);
        this.em.flush();
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.realm.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.realm.setAdminEventsDetailsEnabled(enabled);
        this.em.flush();
    }

    public ClientModel getMasterAdminClient() {
        ClientEntity masterAdminClient = this.realm.getMasterAdminClient();
        if (masterAdminClient == null) {
            return null;
        }
        RealmAdapter masterRealm = new RealmAdapter(this.session, this.em, masterAdminClient.getRealm());
        return new ClientAdapter(masterRealm, this.em, this.session, masterAdminClient);
    }

    public void setMasterAdminClient(ClientModel client) {
        ClientEntity appEntity = client != null ? (ClientEntity)this.em.getReference(ClientEntity.class, (Object)client.getId()) : null;
        this.realm.setMasterAdminClient(appEntity);
        this.em.flush();
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        ArrayList<IdentityProviderModel> identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            IdentityProviderModel identityProviderModel = new IdentityProviderModel();
            identityProviderModel.setProviderId(entity.getProviderId());
            identityProviderModel.setAlias(entity.getAlias());
            identityProviderModel.setInternalId(entity.getInternalId());
            identityProviderModel.setConfig(entity.getConfig());
            identityProviderModel.setEnabled(entity.isEnabled());
            identityProviderModel.setTrustEmail(entity.isTrustEmail());
            identityProviderModel.setAuthenticateByDefault(entity.isAuthenticateByDefault());
            identityProviderModel.setFirstBrokerLoginFlowId(entity.getFirstBrokerLoginFlowId());
            identityProviderModel.setPostBrokerLoginFlowId(entity.getPostBrokerLoginFlowId());
            identityProviderModel.setStoreToken(entity.isStoreToken());
            identityProviderModel.setAddReadTokenRoleOnCreate(entity.isAddReadTokenRoleOnCreate());
            identityProviders.add(identityProviderModel);
        }
        return identityProviders;
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        IdentityProviderEntity entity = new IdentityProviderEntity();
        entity.setInternalId(KeycloakModelUtils.generateId());
        entity.setAlias(identityProvider.getAlias());
        entity.setProviderId(identityProvider.getProviderId());
        entity.setEnabled(identityProvider.isEnabled());
        entity.setStoreToken(identityProvider.isStoreToken());
        entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
        entity.setTrustEmail(identityProvider.isTrustEmail());
        entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
        entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
        entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
        entity.setConfig(identityProvider.getConfig());
        this.realm.addIdentityProvider(entity);
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void removeIdentityProviderByAlias(String alias) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getAlias().equals(alias)) continue;
            this.em.remove((Object)entity);
            this.em.flush();
        }
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getInternalId().equals(identityProvider.getInternalId())) continue;
            entity.setAlias(identityProvider.getAlias());
            entity.setEnabled(identityProvider.isEnabled());
            entity.setTrustEmail(identityProvider.isTrustEmail());
            entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
            entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
            entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
            entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
            entity.setStoreToken(identityProvider.isStoreToken());
            entity.setConfig(identityProvider.getConfig());
        }
        this.em.flush();
    }

    public boolean isIdentityFederationEnabled() {
        return !this.realm.getIdentityProviders().isEmpty();
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
        this.em.flush();
    }

    public Set<String> getSupportedLocales() {
        return this.realm.getSupportedLocales();
    }

    public void setSupportedLocales(Set<String> locales) {
        this.realm.setSupportedLocales(locales);
        this.em.flush();
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
        this.em.flush();
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(brokerAlias)) continue;
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        if (this.getIdentityProviderMapperByName(model.getIdentityProviderAlias(), model.getIdentityProviderMapper()) != null) {
            throw new RuntimeException("identity provider mapper name must be unique per identity provider");
        }
        String id = KeycloakModelUtils.generateId();
        IdentityProviderMapperEntity entity = new IdentityProviderMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setRealm(this.realm);
        entity.setConfig(model.getConfig());
        this.em.persist((Object)entity);
        this.realm.getIdentityProviderMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntity(String id) {
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntityByName(String alias, String name) {
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(alias) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity toDelete = this.getIdentityProviderMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.realm.getIdentityProviderMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(mapping.getId());
        entity.setIdentityProviderAlias(mapping.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(mapping.getIdentityProviderMapper());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntityByName(alias, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperModel entityToModel(IdentityProviderMapperEntity entity) {
        IdentityProviderMapperModel mapping = new IdentityProviderMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        mapping.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return mappers;
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        Set<UserFederationMapperEntity> mapperEntities = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity entity : mapperEntities) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return mappers;
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel model) {
        if (this.getUserFederationMapperByName(model.getFederationProviderId(), model.getName()) != null) {
            throw new ModelDuplicateException("User federation mapper must be unique per federation provider. There is already: " + model.getName());
        }
        String id = KeycloakModelUtils.generateId();
        UserFederationMapperEntity entity = new UserFederationMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setFederationProvider(this.getUserFederationProviderEntityById(model.getFederationProviderId()));
        entity.setFederationMapperType(model.getFederationMapperType());
        entity.setRealm(this.realm);
        entity.setConfig(model.getConfig());
        this.em.persist((Object)entity);
        this.realm.getUserFederationMappers().add(entity);
        UserFederationMapperModel mapperModel = this.entityToModel(entity);
        return mapperModel;
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity toDelete = this.getUserFederationMapperEntity(mapper.getId());
        if (toDelete != null) {
            this.realm.getUserFederationMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    protected UserFederationMapperEntity getUserFederationMapperEntity(String id) {
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntityByName(String federationProviderId, String name) {
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProvider().getId()) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    protected Set<UserFederationMapperEntity> getUserFederationMapperEntitiesByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperEntity> mappers = new HashSet<UserFederationMapperEntity>();
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProvider().getId())) continue;
            mappers.add(entity);
        }
        return mappers;
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(mapper.getId());
        entity.setFederationProvider(this.getUserFederationProviderEntityById(mapper.getFederationProviderId()));
        entity.setFederationMapperType(mapper.getFederationMapperType());
        if (entity.getConfig() == null) {
            entity.setConfig(mapper.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapper.getConfig());
        }
        this.em.flush();
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntityByName(federationProviderId, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected UserFederationMapperModel entityToModel(UserFederationMapperEntity entity) {
        UserFederationMapperModel mapper = new UserFederationMapperModel();
        mapper.setId(entity.getId());
        mapper.setName(entity.getName());
        mapper.setFederationProviderId(entity.getFederationProvider().getId());
        mapper.setFederationMapperType(entity.getFederationMapperType());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapper.setConfig(config);
        return mapper;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        String flowId = this.realm.getBrowserFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.realm.setBrowserFlow(flow.getId());
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        String flowId = this.realm.getRegistrationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.realm.setRegistrationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        String flowId = this.realm.getDirectGrantFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.realm.setDirectGrantFlow(flow.getId());
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        String flowId = this.realm.getResetCredentialsFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.realm.setResetCredentialsFlow(flow.getId());
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        String flowId = this.realm.getClientAuthenticationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.realm.setClientAuthenticationFlow(flow.getId());
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        TypedQuery query = this.em.createNamedQuery("getAuthenticationFlowsByRealm", AuthenticationFlowEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List flows = query.getResultList();
        if (flows.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticationFlowModel> models = new LinkedList<AuthenticationFlowModel>();
        for (AuthenticationFlowEntity entity : flows) {
            AuthenticationFlowModel model = this.entityToModel(entity);
            models.add(model);
        }
        return models;
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        for (AuthenticationFlowModel flow : this.getAuthenticationFlows()) {
            if (!flow.getAlias().equals(alias)) continue;
            return flow;
        }
        return null;
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        for (AuthenticatorConfigModel config : this.getAuthenticatorConfigs()) {
            if (!config.getAlias().equals(alias)) continue;
            return config;
        }
        return null;
    }

    protected AuthenticationFlowModel entityToModel(AuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setProviderId(entity.getProviderId());
        model.setDescription(entity.getDescription());
        model.setBuiltIn(entity.isBuiltIn());
        model.setTopLevel(entity.isTopLevel());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        AuthenticationFlowEntity entity = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = new AuthenticationFlowEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
        entity.setRealm(this.realm);
        this.realm.getAuthenticationFlows().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        model.setId(entity.getId());
        return model;
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        TypedQuery query = this.em.createNamedQuery("getAuthenticationExecutionsByFlow", AuthenticationExecutionEntity.class);
        AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.getReference(AuthenticationFlowEntity.class, (Object)flowId);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("parentFlow", (Object)flow);
        List queryResult = query.getResultList();
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionEntity entity : queryResult) {
            AuthenticationExecutionModel model = this.entityToModel(entity);
            executions.add(model);
        }
        Collections.sort(executions, AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
        return executions;
    }

    public AuthenticationExecutionModel entityToModel(AuthenticationExecutionEntity entity) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setRequirement(entity.getRequirement());
        model.setPriority(entity.getPriority());
        model.setAuthenticator(entity.getAuthenticator());
        model.setFlowId(entity.getFlowId());
        model.setParentFlow(entity.getParentFlow().getId());
        model.setAuthenticatorFlow(entity.isAutheticatorFlow());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        return model;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        AuthenticationExecutionEntity entity = (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = new AuthenticationExecutionEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setFlowId(model.getFlowId());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getParentFlow());
        entity.setParentFlow(flow);
        flow.getExecutions().add(entity);
        entity.setRealm(this.realm);
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        this.em.persist((Object)entity);
        this.em.flush();
        model.setId(entity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        entity.setFlowId(model.getFlowId());
        this.em.flush();
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity auth = new AuthenticatorConfigEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setRealm(this.realm);
        auth.setConfig(model.getConfig());
        this.realm.getAuthenticatorConfigs().add(auth);
        this.em.persist((Object)auth);
        this.em.flush();
        model.setId(auth.getId());
        return model;
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        AuthenticatorConfigEntity entity = (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticatorConfigModel entityToModel(AuthenticatorConfigEntity entity) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.em.flush();
    }

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs() {
        LinkedList<AuthenticatorConfigModel> authenticators = new LinkedList<AuthenticatorConfigModel>();
        for (AuthenticatorConfigEntity entity : this.realm.getAuthenticatorConfigs()) {
            authenticators.add(this.entityToModel(entity));
        }
        return authenticators;
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity auth = new RequiredActionProviderEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setName(model.getName());
        auth.setRealm(this.realm);
        auth.setProviderId(model.getProviderId());
        auth.setConfig(model.getConfig());
        auth.setEnabled(model.isEnabled());
        auth.setDefaultAction(model.isDefaultAction());
        this.realm.getRequiredActionProviders().add(auth);
        this.em.persist((Object)auth);
        this.em.flush();
        model.setId(auth.getId());
        return model;
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        RequiredActionProviderEntity entity = (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public RequiredActionProviderModel entityToModel(RequiredActionProviderEntity entity) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setProviderId(entity.getProviderId());
        model.setAlias(entity.getAlias());
        model.setEnabled(entity.isEnabled());
        model.setDefaultAction(entity.isDefaultAction());
        model.setName(entity.getName());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setProviderId(model.getProviderId());
        entity.setEnabled(model.isEnabled());
        entity.setDefaultAction(model.isDefaultAction());
        entity.setName(model.getName());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.em.flush();
    }

    public List<RequiredActionProviderModel> getRequiredActionProviders() {
        LinkedList<RequiredActionProviderModel> actions = new LinkedList<RequiredActionProviderModel>();
        for (RequiredActionProviderEntity entity : this.realm.getRequiredActionProviders()) {
            actions.add(this.entityToModel(entity));
        }
        return actions;
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        for (RequiredActionProviderModel action : this.getRequiredActionProviders()) {
            if (!action.getAlias().equals(alias)) continue;
            return action;
        }
        return null;
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        } else {
            this.addTopLevelGroup(group);
        }
    }

    public GroupModel getGroupById(String id) {
        return this.session.realms().getGroupById(id, (RealmModel)this);
    }

    public List<GroupModel> getGroups() {
        LinkedList<GroupModel> list = new LinkedList<GroupModel>();
        List groups = this.em.createNamedQuery("getAllGroupsByRealm").setParameter("realm", (Object)this.realm).getResultList();
        if (groups == null) {
            return list;
        }
        for (GroupEntity entity : groups) {
            list.add(new GroupAdapter(this, this.em, entity));
        }
        return list;
    }

    public List<GroupModel> getTopLevelGroups() {
        List<GroupModel> all = this.getGroups();
        Iterator<GroupModel> it = all.iterator();
        while (it.hasNext()) {
            GroupModel group = it.next();
            if (group.getParent() == null) continue;
            it.remove();
        }
        return all;
    }

    public boolean removeGroup(GroupModel group) {
        if (group == null) {
            return false;
        }
        GroupEntity groupEntity = GroupAdapter.toEntity(group, this.em);
        if (!groupEntity.getRealm().getId().equals(this.getId())) {
            return false;
        }
        this.realm.getDefaultGroups().remove(groupEntity);
        for (GroupModel subGroup : group.getSubGroups()) {
            this.removeGroup(subGroup);
        }
        this.session.users().preRemove((RealmModel)this, group);
        this.moveGroup(group, null);
        this.em.createNamedQuery("deleteGroupAttributesByGroup").setParameter("group", (Object)groupEntity).executeUpdate();
        this.em.createNamedQuery("deleteGroupRoleMappingsByGroup").setParameter("group", (Object)groupEntity).executeUpdate();
        this.em.remove((Object)groupEntity);
        return true;
    }

    public GroupModel createGroup(String name) {
        String id = KeycloakModelUtils.generateId();
        return this.createGroup(id, name);
    }

    public GroupModel createGroup(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        GroupEntity groupEntity = new GroupEntity();
        groupEntity.setId(id);
        groupEntity.setName(name);
        groupEntity.setRealm(this.realm);
        this.em.persist((Object)groupEntity);
        return new GroupAdapter(this, this.em, groupEntity);
    }

    public void addTopLevelGroup(GroupModel subGroup) {
        subGroup.setParent(null);
    }

    public List<ClientTemplateModel> getClientTemplates() {
        LinkedList<ClientTemplateModel> list = new LinkedList<ClientTemplateModel>();
        if (this.realm.getClientTemplates() == null) {
            return list;
        }
        for (ClientTemplateEntity entity : this.realm.getClientTemplates()) {
            list.add(new ClientTemplateAdapter(this, this.em, this.session, entity));
        }
        return list;
    }

    public ClientTemplateModel addClientTemplate(String name) {
        return this.addClientTemplate(KeycloakModelUtils.generateId(), name);
    }

    public ClientTemplateModel addClientTemplate(String id, String name) {
        ClientTemplateEntity entity = new ClientTemplateEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealm(this.realm);
        this.realm.getClientTemplates().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        ClientTemplateAdapter resource = new ClientTemplateAdapter(this, this.em, this.session, entity);
        this.em.flush();
        return resource;
    }

    public boolean removeClientTemplate(String id) {
        if (id == null) {
            return false;
        }
        ClientTemplateModel client = this.getClientTemplateById(id);
        if (client == null) {
            return false;
        }
        ClientTemplateEntity clientEntity = null;
        Iterator<ClientTemplateEntity> it = this.realm.getClientTemplates().iterator();
        while (it.hasNext()) {
            ClientTemplateEntity ae = it.next();
            if (!ae.getId().equals(id)) continue;
            clientEntity = ae;
            it.remove();
            break;
        }
        if (client == null) {
            return false;
        }
        this.em.createNamedQuery("deleteTemplateScopeMappingByClient").setParameter("template", clientEntity).executeUpdate();
        this.em.flush();
        this.em.remove((Object)clientEntity);
        this.em.flush();
        return true;
    }

    public ClientTemplateModel getClientTemplateById(String id) {
        return this.session.realms().getClientTemplateById(id, (RealmModel)this);
    }
}

