/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.keycloak.common.util.Base64;

public class SHAPasswordEncoder {
    private int strength;

    public SHAPasswordEncoder(int strength) {
        this.strength = strength;
    }

    public String encode(String rawPassword) {
        MessageDigest messageDigest = this.getMessageDigest();
        String encodedPassword = null;
        try {
            byte[] digest = messageDigest.digest(rawPassword.getBytes("UTF-8"));
            encodedPassword = Base64.encodeBytes((byte[])digest);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Credential could not be encoded");
        }
        return encodedPassword;
    }

    public boolean verify(String rawPassword, String encodedPassword) {
        return this.encode(rawPassword).equals(encodedPassword);
    }

    protected final MessageDigest getMessageDigest() throws IllegalArgumentException {
        String algorithm = "SHA-" + this.strength;
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("invalid credential encoding algorithm");
        }
    }

    public int getStrength() {
        return this.strength;
    }
}

