/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers.membership.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.federation.ldap.mappers.membership.MembershipType;
import org.keycloak.federation.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.federation.ldap.mappers.membership.group.GroupLDAPFederationMapper;
import org.keycloak.mappers.MapperConfigValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.UserFederationMapperSyncConfigRepresentation;

public class GroupLDAPFederationMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "group-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    protected static final Map<String, UserRolesRetrieveStrategy> userGroupsStrategies = new LinkedHashMap<String, UserRolesRetrieveStrategy>();

    public String getHelpText() {
        return "Used to map group mappings of groups from some LDAP DN to Keycloak group mappings";
    }

    public String getDisplayCategory() {
        return "Group Mapper";
    }

    public String getDisplayType() {
        return "Group mappings";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public Map<String, String> getDefaultConfig(UserFederationProviderModel providerModel) {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        LDAPConfig config = new LDAPConfig(providerModel.getConfig());
        defaultValues.put("group.name.ldap.attribute", "cn");
        String roleObjectClasses = config.isActiveDirectory() ? "group" : "groupOfNames";
        defaultValues.put("group.object.classes", roleObjectClasses);
        defaultValues.put("preserve.group.inheritance", "true");
        defaultValues.put("membership.ldap.attribute", "member");
        String mode = config.getEditMode() == UserFederationProvider.EditMode.WRITABLE ? LDAPGroupMapperMode.LDAP_ONLY.toString() : LDAPGroupMapperMode.READ_ONLY.toString();
        defaultValues.put("mode", mode);
        defaultValues.put("user.roles.retrieve.strategy", "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE");
        defaultValues.put("drop.non.existing.groups.during.sync", "false");
        return defaultValues;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public UserFederationMapperSyncConfigRepresentation getSyncConfig() {
        return new UserFederationMapperSyncConfigRepresentation(true, "sync-ldap-groups-to-keycloak", true, "sync-keycloak-groups-to-ldap");
    }

    public void validateConfig(RealmModel realm, UserFederationMapperModel mapperModel) throws MapperConfigValidationException {
        this.checkMandatoryConfigAttribute("groups.dn", "LDAP Groups DN", mapperModel);
        this.checkMandatoryConfigAttribute("mode", "Mode", mapperModel);
        String mt = (String)mapperModel.getConfig().get("membership.attribute.type");
        MembershipType membershipType = mt == null ? MembershipType.DN : Enum.valueOf(MembershipType.class, mt);
        boolean preserveGroupInheritance = Boolean.parseBoolean((String)mapperModel.getConfig().get("preserve.group.inheritance"));
        if (preserveGroupInheritance && membershipType != MembershipType.DN) {
            throw new MapperConfigValidationException("Not possible to preserve group inheritance and use UID membership type together");
        }
    }

    @Override
    protected AbstractLDAPFederationMapper createMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider federationProvider, RealmModel realm) {
        return new GroupLDAPFederationMapper(mapperModel, federationProvider, realm, this);
    }

    protected UserRolesRetrieveStrategy getUserGroupsRetrieveStrategy(String strategyKey) {
        return userGroupsStrategies.get(strategyKey);
    }

    static {
        userGroupsStrategies.put("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE", new UserRolesRetrieveStrategy.LoadRolesByMember());
        userGroupsStrategies.put("GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE", new UserRolesRetrieveStrategy.GetRolesFromUserMemberOfAttribute());
        userGroupsStrategies.put("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY", new UserRolesRetrieveStrategy.LoadRolesByMemberRecursively());
        ProviderConfigProperty groupsDn = GroupLDAPFederationMapperFactory.createConfigProperty("groups.dn", "LDAP Groups DN", "LDAP DN where are groups of this tree saved. For example 'ou=groups,dc=example,dc=org' ", "String", null);
        configProperties.add(groupsDn);
        ProviderConfigProperty groupNameLDAPAttribute = GroupLDAPFederationMapperFactory.createConfigProperty("group.name.ldap.attribute", "Group Name LDAP Attribute", "Name of LDAP attribute, which is used in group objects for name and RDN of group. Usually it will be 'cn' . In this case typical group/role object may have DN like 'cn=Group1,ou=groups,dc=example,dc=org' ", "String", null);
        configProperties.add(groupNameLDAPAttribute);
        ProviderConfigProperty groupObjectClasses = GroupLDAPFederationMapperFactory.createConfigProperty("group.object.classes", "Group Object Classes", "Object class (or classes) of the group object. It's divided by comma if more classes needed. In typical LDAP deployment it could be 'groupOfNames' . In Active Directory it's usually 'group' ", "String", null);
        configProperties.add(groupObjectClasses);
        ProviderConfigProperty preserveGroupInheritance = GroupLDAPFederationMapperFactory.createConfigProperty("preserve.group.inheritance", "Preserve Group Inheritance", "Flag whether group inheritance from LDAP should be propagated to Keycloak. If false, then all LDAP groups will be mapped as flat top-level groups in Keycloak. Otherwise group inheritance is preserved into Keycloak, but the group sync might fail if LDAP structure contains recursions or multiple parent groups per child groups", "boolean", null);
        configProperties.add(preserveGroupInheritance);
        ProviderConfigProperty membershipLDAPAttribute = GroupLDAPFederationMapperFactory.createConfigProperty("membership.ldap.attribute", "Membership LDAP Attribute", "Name of LDAP attribute on group, which is used for membership mappings. Usually it will be 'member' ", "String", null);
        configProperties.add(membershipLDAPAttribute);
        LinkedList<String> membershipTypes = new LinkedList<String>();
        for (MembershipType membershipType : MembershipType.values()) {
            membershipTypes.add(membershipType.toString());
        }
        ProviderConfigProperty membershipType = GroupLDAPFederationMapperFactory.createConfigProperty("membership.attribute.type", "Membership Attribute Type", "DN means that LDAP role has it's members declared in form of their full DN. For example 'member: uid=john,ou=users,dc=example,dc=com' . UID means that LDAP role has it's members declared in form of pure user uids. For example 'memberUid: john' .", "List", membershipTypes);
        configProperties.add(membershipType);
        ProviderConfigProperty ldapFilter = GroupLDAPFederationMapperFactory.createConfigProperty("groups.ldap.filter", "LDAP Filter", "LDAP Filter adds additional custom filter to the whole query for retrieve LDAP groups. Leave this empty if no additional filtering is needed and you want to retrieve all groups from LDAP. Otherwise make sure that filter starts with '(' and ends with ')'", "String", null);
        configProperties.add(ldapFilter);
        LinkedList<String> modes = new LinkedList<String>();
        for (LDAPGroupMapperMode mode : LDAPGroupMapperMode.values()) {
            modes.add(mode.toString());
        }
        ProviderConfigProperty providerConfigProperty = GroupLDAPFederationMapperFactory.createConfigProperty("mode", "Mode", "LDAP_ONLY means that all group mappings of users are retrieved from LDAP and saved into LDAP. READ_ONLY is Read-only LDAP mode where group mappings are retrieved from both LDAP and DB and merged together. New group joins are not saved to LDAP but to DB. IMPORT is Read-only LDAP mode where group mappings are retrieved from LDAP just at the time when user is imported from LDAP and then they are saved to local keycloak DB.", "List", modes);
        configProperties.add(providerConfigProperty);
        LinkedList<String> roleRetrievers = new LinkedList<String>(userGroupsStrategies.keySet());
        ProviderConfigProperty retriever = GroupLDAPFederationMapperFactory.createConfigProperty("user.roles.retrieve.strategy", "User Groups Retrieve Strategy", "Specify how to retrieve groups of user. LOAD_GROUPS_BY_MEMBER_ATTRIBUTE means that roles of user will be retrieved by sending LDAP query to retrieve all groups where 'member' is our user. GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE means that groups of user will be retrieved from 'memberOf' attribute of our user. LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY is applicable just in Active Directory and it means that groups of user will be retrieved recursively with usage of LDAP_MATCHING_RULE_IN_CHAIN Ldap extension.", "List", roleRetrievers);
        configProperties.add(retriever);
        ProviderConfigProperty mappedGroupAttributes = GroupLDAPFederationMapperFactory.createConfigProperty("mapped.group.attributes", "Mapped Group Attributes", "List of names of attributes divided by comma. This points to the list of attributes on LDAP group, which will be mapped as attributes of Group in Keycloak. Leave this empty if no additional group attributes are required to be mapped in Keycloak. ", "String", null);
        configProperties.add(mappedGroupAttributes);
        ProviderConfigProperty dropNonExistingGroupsDuringSync = GroupLDAPFederationMapperFactory.createConfigProperty("drop.non.existing.groups.during.sync", "Drop non-existing groups during sync", "If this flag is true, then during sync of groups from LDAP to Keycloak, we will keep just those Keycloak groups, which still exists in LDAP. Rest will be deleted", "boolean", null);
        configProperties.add(dropNonExistingGroupsDuringSync);
    }
}

