/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import liquibase.database.core.DerbyDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.StandardLockService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.connections.jpa.updater.liquibase.lock.LockRetryException;

public class CustomLockService
extends StandardLockService {
    private static final Logger log = Logger.getLogger(CustomLockService.class);

    public void init() throws DatabaseException {
        boolean createdTable = false;
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        if (!this.hasDatabaseChangeLogLockTable()) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Create Database Lock Table");
                }
                executor.execute((SqlStatement)new CreateDatabaseChangeLogLockTableStatement());
                this.database.commit();
            }
            catch (DatabaseException de) {
                log.warn((Object)"Failed to create lock table. Maybe other transaction created in the meantime. Retrying...");
                if (log.isTraceEnabled()) {
                    log.trace((Object)de.getMessage(), (Throwable)de);
                }
                this.database.rollback();
                throw new LockRetryException(de);
            }
            log.debugf("Created database lock table with name: %s", (Object)this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            try {
                Field field = Reflections.findDeclaredField(StandardLockService.class, (String)"hasDatabaseChangeLogLockTable");
                Reflections.setAccessible((AccessibleObject)field);
                field.set((Object)this, true);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            createdTable = true;
        }
        if (!this.isDatabaseChangeLogLockTableInitialized(createdTable)) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Initialize Database Lock Table");
                }
                executor.execute((SqlStatement)new InitializeDatabaseChangeLogLockTableStatement());
                this.database.commit();
            }
            catch (DatabaseException de) {
                log.warn((Object)"Failed to insert first record to the lock table. Maybe other transaction inserted in the meantime. Retrying...");
                if (log.isTraceEnabled()) {
                    log.trace((Object)de.getMessage(), (Throwable)de);
                }
                this.database.rollback();
                throw new LockRetryException(de);
            }
            log.debug((Object)"Initialized record in the database lock table");
        }
        if (executor.updatesDatabase() && this.database instanceof DerbyDatabase && ((DerbyDatabase)this.database).supportsBooleanDataType()) {
            String lockTable = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            Object obj = executor.queryForObject((SqlStatement)new RawSqlStatement("select min(locked) as test from " + lockTable + " fetch first row only"), Object.class);
            if (!(obj instanceof Boolean)) {
                executor.execute((SqlStatement)new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                executor.execute((SqlStatement)new CreateDatabaseChangeLogLockTableStatement());
                executor.execute((SqlStatement)new InitializeDatabaseChangeLogLockTableStatement());
            }
        }
    }

    public void waitForLock() {
        boolean locked = false;
        long startTime = Time.toMillis((int)Time.currentTime());
        long timeToGiveUp = startTime + this.getChangeLogLockWaitTime();
        boolean nextAttempt = true;
        while (nextAttempt) {
            locked = this.acquireLock();
            if (!locked) {
                int remainingTime = (int)(timeToGiveUp / 1000L) - Time.currentTime();
                if (remainingTime > 0) {
                    log.debugf("Will try to acquire log another time. Remaining time: %d seconds", remainingTime);
                    continue;
                }
                nextAttempt = false;
                continue;
            }
            nextAttempt = false;
        }
        if (!locked) {
            int timeout = (int)(this.getChangeLogLockWaitTime() / 1000L);
            throw new IllegalStateException("Could not acquire change log lock within specified timeout " + timeout + " seconds.  Currently locked by other transaction");
        }
    }

    public boolean acquireLock() {
        if (this.hasChangeLogLock) {
            return true;
        }
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            this.database.rollback();
            this.init();
        }
        catch (DatabaseException de) {
            throw new IllegalStateException("Failed to retrieve lock", de);
        }
        try {
            log.debug((Object)"Trying to lock database");
            executor.execute((SqlStatement)new LockDatabaseChangeLogStatement());
            log.debug((Object)"Successfully acquired database lock");
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            return true;
        }
        catch (DatabaseException de) {
            log.warn((Object)("Lock didn't yet acquired. Will possibly retry to acquire lock. Details: " + de.getMessage()));
            if (log.isTraceEnabled()) {
                log.debug((Object)de.getMessage(), (Throwable)de);
            }
            return false;
        }
    }

    public void releaseLock() {
        try {
            if (this.hasChangeLogLock) {
                log.debug((Object)"Going to release database lock");
                this.database.commit();
            } else {
                log.warn((Object)"Attempt to release lock, which is not owned by current transaction");
            }
        }
        catch (Exception e) {
            log.error((Object)"Database error during release lock", (Throwable)e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
    }
}

