/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.model.IConfigMapKeySelector;
import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.IObjectFieldSelector;
import com.openshift.restclient.model.ISecretKeySelector;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class EnvironmentVariable
extends ModelNodeAdapter
implements IEnvironmentVariable,
ResourcePropertyKeys {
    public EnvironmentVariable(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "name");
    }

    @Override
    public String getValue() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "value");
    }

    @Override
    public IEnvironmentVariable.IEnvVarSource getValueFrom() {
        if (this.getNode().hasDefined("fieldRef")) {
            return new IObjectFieldSelector(){

                @Override
                public String getApiVersion() {
                    return JBossDmrExtentions.asString(EnvironmentVariable.this.getNode(), EnvironmentVariable.this.getPropertyKeys(), "fieldRef.apiVersion");
                }

                @Override
                public String getFieldPath() {
                    return JBossDmrExtentions.asString(EnvironmentVariable.this.getNode(), EnvironmentVariable.this.getPropertyKeys(), "fieldRef.fieldPath");
                }
            };
        }
        if (this.getNode().hasDefined("configMapKeyRef")) {
            return new IConfigMapKeySelector(){

                @Override
                public String getName() {
                    return JBossDmrExtentions.asString(EnvironmentVariable.this.getNode(), EnvironmentVariable.this.getPropertyKeys(), "configMapKeyRef.name");
                }

                @Override
                public String getKey() {
                    return JBossDmrExtentions.asString(EnvironmentVariable.this.getNode(), EnvironmentVariable.this.getPropertyKeys(), "configMapKeyRef.key");
                }
            };
        }
        if (this.getNode().hasDefined("secretKeyRef")) {
            return new ISecretKeySelector(){

                @Override
                public String getName() {
                    return JBossDmrExtentions.asString(EnvironmentVariable.this.getNode(), EnvironmentVariable.this.getPropertyKeys(), "secretKeyRef.name");
                }

                @Override
                public String getKey() {
                    return JBossDmrExtentions.asString(EnvironmentVariable.this.getNode(), EnvironmentVariable.this.getPropertyKeys(), "secretKeyRef.key");
                }
            };
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IEnvironmentVariable)) {
            return false;
        }
        IEnvironmentVariable otherVar = (IEnvironmentVariable)object;
        String thisName = this.getName();
        String otherName = otherVar.getName();
        if (thisName == null ? otherName != null : !thisName.equals(otherName)) {
            return false;
        }
        String thisValue = this.getValue();
        String otherValue = otherVar.getValue();
        return !(thisValue == null ? otherValue != null : !thisValue.equals(otherValue));
    }

    public int hashCode() {
        String name = this.getName();
        String value = this.getValue();
        return 37 * (name == null ? 0 : name.hashCode()) + (value == null ? 0 : value.hashCode());
    }
}

