/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.authorization.AuthorizationDetails;
import com.openshift.internal.restclient.okhttp.BasicChallangeHandler;
import com.openshift.internal.restclient.okhttp.IChallangeHandler;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.internal.util.URIUtils;
import com.openshift.restclient.IClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.http.IHttpConstants;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.StringUtils;

public class OpenShiftAuthenticator
implements Authenticator,
IHttpConstants {
    public static final String ACCESS_TOKEN = "access_token";
    private static final String AUTH_ATTEMPTS = "X-OPENSHIFT-AUTH-ATTEMPTS";
    private static final String CSRF_TOKEN = "X-CSRF-Token";
    private static final String ERROR = "error";
    private static final String ERROR_DETAILS = "error_details";
    private Collection<IChallangeHandler> challangeHandlers = new ArrayList<IChallangeHandler>();
    private OkHttpClient okClient;
    private IClient client;

    public Request authenticate(Route route, Response response) throws IOException {
        if (this.unauthorizedForCluster(response)) {
            String requestUrl = response.request().url().toString();
            Request authRequest = new Request.Builder().addHeader(CSRF_TOKEN, "1").url(new URL(this.client.getAuthorizationEndpoint().toExternalForm() + "?response_type=token&client_id=openshift-challenging-client").toString()).build();
            try (Response authResponse = this.tryAuth(authRequest);){
                if (authResponse.isSuccessful()) {
                    String token = this.extractAndSetAuthContextToken(authResponse);
                    Request request = response.request().newBuilder().header("Authorization", String.format("%s %s", "Bearer", token)).build();
                    return request;
                }
            }
            throw new UnauthorizedException(this.captureAuthDetails(requestUrl), ResponseCodeInterceptor.getStatus(response.body().string()));
        }
        return null;
    }

    private boolean unauthorizedForCluster(Response response) {
        String requestHost = response.request().url().host();
        return response.code() == 401 && this.client.getBaseURL().getHost().equals(requestHost);
    }

    private Response tryAuth(Request authRequest) throws IOException {
        return this.okClient.newBuilder().authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                if (StringUtils.isNotBlank((String)response.request().header(OpenShiftAuthenticator.AUTH_ATTEMPTS))) {
                    return null;
                }
                if (StringUtils.isNotBlank((String)response.header("Www-Authenticate"))) {
                    for (IChallangeHandler challangeHandler : OpenShiftAuthenticator.this.challangeHandlers) {
                        if (challangeHandler.canHandle(response.headers())) continue;
                        Request.Builder requestBuilder = response.request().newBuilder().header(OpenShiftAuthenticator.AUTH_ATTEMPTS, "1");
                        return challangeHandler.handleChallange(requestBuilder).build();
                    }
                }
                return null;
            }
        }).followRedirects(false).followRedirects(false).build().newCall(authRequest).execute();
    }

    private IAuthorizationDetails captureAuthDetails(String url) {
        AuthorizationDetails details = null;
        Map<String, String> pairs = URIUtils.splitFragment(url);
        if (pairs.containsKey(ERROR)) {
            details = new AuthorizationDetails(pairs.get(ERROR), pairs.get(ERROR_DETAILS));
        }
        return details;
    }

    private String extractAndSetAuthContextToken(Response response) {
        String token = null;
        Map<String, String> pairs = URIUtils.splitFragment(response.header("Location"));
        if (pairs.containsKey(ACCESS_TOKEN)) {
            token = pairs.get(ACCESS_TOKEN);
            IAuthorizationContext authContext = this.client.getAuthorizationContext();
            if (authContext != null) {
                authContext.setToken(token);
            }
        }
        return token;
    }

    public void setOkClient(OkHttpClient okClient) {
        this.okClient = okClient;
    }

    public void setClient(DefaultClient client) {
        this.client = client;
        this.challangeHandlers.clear();
        this.challangeHandlers.add(new BasicChallangeHandler(client.getAuthorizationContext()));
    }
}

