/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.conn;

import java.sql.Connection;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.LogLevel;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.updater.liquibase.MySQL8VarcharType;
import org.keycloak.connections.jpa.updater.liquibase.PostgresPlusDatabase;
import org.keycloak.connections.jpa.updater.liquibase.UpdatedMariaDBDatabase;
import org.keycloak.connections.jpa.updater.liquibase.UpdatedMySqlDatabase;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomInsertLockRecordGenerator;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomLockDatabaseChangeLogGenerator;
import org.keycloak.connections.jpa.updater.liquibase.lock.DummyLockService;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultLiquibaseConnectionProvider
implements LiquibaseConnectionProviderFactory,
LiquibaseConnectionProvider {
    private static final Logger logger = Logger.getLogger(DefaultLiquibaseConnectionProvider.class);
    private volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiquibaseConnectionProvider create(KeycloakSession session) {
        if (!this.initialized) {
            DefaultLiquibaseConnectionProvider defaultLiquibaseConnectionProvider = this;
            synchronized (defaultLiquibaseConnectionProvider) {
                if (!this.initialized) {
                    this.baseLiquibaseInitialization();
                    this.initialized = true;
                }
            }
        }
        return this;
    }

    protected void baseLiquibaseInitialization() {
        ServiceLocator sl = ServiceLocator.getInstance();
        sl.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor(this.getClass().getClassLoader()));
        if (!System.getProperties().containsKey("liquibase.scan.packages")) {
            if (sl.getPackages().remove("liquibase.core")) {
                sl.addPackageToScan("liquibase.core.xml");
            }
            if (sl.getPackages().remove("liquibase.parser")) {
                sl.addPackageToScan("liquibase.parser.core.xml");
            }
            if (sl.getPackages().remove("liquibase.serializer")) {
                sl.addPackageToScan("liquibase.serializer.core.xml");
            }
            sl.getPackages().remove("liquibase.ext");
            sl.getPackages().remove("liquibase.sdk");
            String lockPackageName = DummyLockService.class.getPackage().getName();
            logger.debugf("Added package %s to liquibase", (Object)lockPackageName);
            sl.addPackageToScan(lockPackageName);
        }
        LogFactory.setInstance((LogFactory)new LogWrapper());
        DatabaseFactory.getInstance().register((Database)new PostgresPlusDatabase());
        DatabaseFactory.getInstance().register((Database)new UpdatedMySqlDatabase());
        DatabaseFactory.getInstance().register((Database)new UpdatedMariaDBDatabase());
        DataTypeFactory.getInstance().register(MySQL8VarcharType.class);
        SqlGeneratorFactory.getInstance().register((SqlGenerator)new CustomInsertLockRecordGenerator());
        SqlGeneratorFactory.getInstance().register((SqlGenerator)new CustomLockDatabaseChangeLogGenerator());
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    @Override
    public Liquibase getLiquibase(Connection connection, String defaultSchema) throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        String changelog = "META-INF/jpa-changelog-master.xml";
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelog, (Object)database.getDatabaseChangeLogTableName());
        return new Liquibase(changelog, (ResourceAccessor)resourceAccessor, database);
    }

    @Override
    public Liquibase getLiquibaseForCustomUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(classloader);
        database.setDatabaseChangeLogTableName(changelogTableName);
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelogLocation, (Object)database.getDatabaseChangeLogTableName());
        return new Liquibase(changelogLocation, (ResourceAccessor)resourceAccessor, database);
    }

    private static class LogWrapper
    extends LogFactory {
        private static final liquibase.logging.Logger logger = new liquibase.logging.Logger(){

            public void setName(String name) {
            }

            public void setLogLevel(String level) {
            }

            public void setLogLevel(LogLevel level) {
            }

            public void setLogLevel(String logLevel, String logFile) {
            }

            public void severe(String message) {
                logger.error((Object)message);
            }

            public void severe(String message, Throwable e) {
                logger.error((Object)message, e);
            }

            public void warning(String message) {
                if ("Database does not support drop with cascade".equals(message)) {
                    logger.debug((Object)message);
                } else {
                    logger.warn((Object)message);
                }
            }

            public void warning(String message, Throwable e) {
                logger.warn((Object)message, e);
            }

            public void info(String message) {
                logger.debug((Object)message);
            }

            public void info(String message, Throwable e) {
                logger.debug((Object)message, e);
            }

            public void debug(String message) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)message);
                }
            }

            public LogLevel getLogLevel() {
                if (logger.isTraceEnabled()) {
                    return LogLevel.DEBUG;
                }
                if (logger.isDebugEnabled()) {
                    return LogLevel.INFO;
                }
                return LogLevel.WARNING;
            }

            public void debug(String message, Throwable e) {
                logger.trace((Object)message, e);
            }

            public void setChangeLog(DatabaseChangeLog databaseChangeLog) {
            }

            public void setChangeSet(ChangeSet changeSet) {
            }

            public int getPriority() {
                return 0;
            }

            public void closeLogFile() {
            }
        };

        private LogWrapper() {
        }

        public liquibase.logging.Logger getLog(String name) {
            return logger;
        }

        public liquibase.logging.Logger getLog() {
            return logger;
        }
    }
}

