/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class AuthenticationParameters
implements Serializable {
    private final ServerProperty serverProperty;
    private final Authenticator authenticator;
    private boolean userVerificationRequired;
    private boolean userPresenceRequired;
    private List<String> expectedExtensionIds;

    public AuthenticationParameters(ServerProperty serverProperty, Authenticator authenticator, boolean userVerificationRequired, boolean userPresenceRequired, List<String> expectedExtensionIds) {
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
        this.expectedExtensionIds = CollectionUtil.unmodifiableList(expectedExtensionIds);
    }

    public AuthenticationParameters(ServerProperty serverProperty, Authenticator authenticator, boolean userVerificationRequired, boolean userPresenceRequired) {
        this(serverProperty, authenticator, userVerificationRequired, userPresenceRequired, null);
    }

    public AuthenticationParameters(ServerProperty serverProperty, Authenticator authenticator, boolean userVerificationRequired) {
        this(serverProperty, authenticator, userVerificationRequired, true);
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public List<String> getExpectedExtensionIds() {
        return this.expectedExtensionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationParameters that = (AuthenticationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.expectedExtensionIds, that.expectedExtensionIds);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.authenticator, this.userVerificationRequired, this.userPresenceRequired, this.expectedExtensionIds);
    }
}

