/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class PublicKeyStorageInvalidationEvent
extends InvalidationEvent {
    private String cacheKey;

    public static PublicKeyStorageInvalidationEvent create(String cacheKey) {
        PublicKeyStorageInvalidationEvent event = new PublicKeyStorageInvalidationEvent();
        event.cacheKey = cacheKey;
        return event;
    }

    @Override
    public String getId() {
        return this.cacheKey;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public String toString() {
        return "PublicKeyStorageInvalidationEvent [ " + this.cacheKey + " ]";
    }

    public static class ExternalizerImpl
    implements Externalizer<PublicKeyStorageInvalidationEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, PublicKeyStorageInvalidationEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.cacheKey, (ObjectOutput)output);
        }

        public PublicKeyStorageInvalidationEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public PublicKeyStorageInvalidationEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            PublicKeyStorageInvalidationEvent res = new PublicKeyStorageInvalidationEvent();
            res.cacheKey = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

