/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.entities.PermissionTicketQuery;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class PermissionTicketListQuery
extends AbstractRevisioned
implements PermissionTicketQuery {
    private final Set<String> permissions;
    private final String serverId;

    public PermissionTicketListQuery(Long revision, String id, String permissionId, String serverId) {
        super(revision, id);
        this.serverId = serverId;
        this.permissions = new HashSet<String>();
        this.permissions.add(permissionId);
    }

    public PermissionTicketListQuery(Long revision, String id, Set<String> permissions, String serverId) {
        super(revision, id);
        this.serverId = serverId;
        this.permissions = permissions;
    }

    @Override
    public String getResourceServerId() {
        return this.serverId;
    }

    @Override
    public Set<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isInvalid(Set<String> invalidations) {
        return invalidations.contains(this.getId()) || invalidations.contains(this.getResourceServerId());
    }
}

