/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration;

import org.jboss.logging.Logger;

public class ModelVersion {
    private static Logger logger = Logger.getLogger(ModelVersion.class);
    int major;
    int minor;
    int micro;
    String qualifier;

    public ModelVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public ModelVersion(String version) {
        version = version.split("-")[0];
        String[] split = version.split("\\.");
        try {
            if (split.length > 0) {
                this.major = Integer.parseInt(split[0]);
            }
            if (split.length > 1) {
                this.minor = Integer.parseInt(split[1]);
            }
            if (split.length > 2) {
                this.micro = Integer.parseInt(split[2]);
            }
            if (split.length > 3) {
                this.qualifier = split[3];
                if (this.qualifier.startsWith("redhat")) {
                    this.qualifier = null;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)("failed to parse version: " + version), (Throwable)e);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean lessThan(ModelVersion version) {
        if (this.major < version.major) {
            return true;
        }
        if (this.major > version.major) {
            return false;
        }
        if (this.minor < version.minor) {
            return true;
        }
        if (this.minor > version.minor) {
            return false;
        }
        if (this.micro < version.micro) {
            return true;
        }
        if (this.minor > version.minor) {
            return false;
        }
        if (this.qualifier != null && this.qualifier.equals(version.qualifier)) {
            return false;
        }
        if (this.qualifier == null) {
            return false;
        }
        if (version.qualifier == null) {
            return true;
        }
        int comp = this.qualifier.compareTo(version.qualifier);
        if (comp < 0) {
            return true;
        }
        if (comp > 0) {
            return false;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModelVersion)) {
            return false;
        }
        ModelVersion v = (ModelVersion)obj;
        return v.getMajor() == this.major && v.getMinor() == this.minor && v.getMicro() == this.micro;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }
}

