/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo1_6_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.6.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        MigrationProvider provider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        ProtocolMapperModel localeMapper = provider.getBuiltinMappers("openid-connect").get("locale");
        if (localeMapper == null) {
            throw new RuntimeException("Can't find default locale mapper");
        }
        List realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            this.migrateRealm(session, localeMapper, realm);
        }
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        MigrationProvider provider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        ProtocolMapperModel localeMapper = provider.getBuiltinMappers("openid-connect").get("locale");
        if (localeMapper == null) {
            throw new RuntimeException("Can't find default locale mapper");
        }
        this.migrateRealm(session, localeMapper, realm);
    }

    protected void migrateRealm(KeycloakSession session, ProtocolMapperModel localeMapper, RealmModel realm) {
        RoleModel role;
        ClientModel client;
        ClientModel adminConsoleClient;
        realm.setOfflineSessionIdleTimeout(2592000);
        if (realm.getRole("offline_access") == null) {
            KeycloakModelUtils.setupOfflineRole(realm);
            RoleModel role2 = realm.getRole("offline_access");
            session.users().grantToAllUsers(realm, role2);
        }
        if ((adminConsoleClient = realm.getClientByClientId("security-admin-console")) != null && !this.localeMapperAdded(adminConsoleClient)) {
            adminConsoleClient.addProtocolMapper(localeMapper);
        }
        if ((client = realm.getMasterAdminClient()).getRole(AdminRoles.CREATE_CLIENT) == null) {
            role = client.addRole(AdminRoles.CREATE_CLIENT);
            role.setDescription("${role_" + AdminRoles.CREATE_CLIENT + "}");
            client.getRealm().getRole(AdminRoles.ADMIN).addCompositeRole(role);
        }
        if (!realm.getName().equals(Config.getAdminRealm()) && (client = realm.getClientByClientId("realm-management")).getRole(AdminRoles.CREATE_CLIENT) == null) {
            role = client.addRole(AdminRoles.CREATE_CLIENT);
            role.setDescription("${role_" + AdminRoles.CREATE_CLIENT + "}");
            client.getRole(AdminRoles.REALM_ADMIN).addCompositeRole(role);
        }
    }

    private boolean localeMapperAdded(ClientModel adminConsoleClient) {
        return adminConsoleClient.getProtocolMapperByName("openid-connect", "locale") != null;
    }
}

