/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.HashMap;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.ScriptBasedAuthenticator;
import org.keycloak.authentication.authenticators.browser.ScriptBasedAuthenticatorFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.provider.ScriptProviderMetadata;

public final class DeployedScriptAuthenticatorFactory
extends ScriptBasedAuthenticatorFactory {
    private final AuthenticatorConfigModel model = new AuthenticatorConfigModel();

    public DeployedScriptAuthenticatorFactory(ScriptProviderMetadata metadata) {
        this.model.setId(metadata.getId());
        this.model.setAlias(metadata.getName());
        this.model.setConfig(new HashMap());
        this.model.getConfig().put("scriptName", metadata.getName());
        this.model.getConfig().put("scriptCode", metadata.getCode());
        this.model.getConfig().put("scriptDescription", metadata.getDescription());
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return new ScriptBasedAuthenticator(){

            @Override
            protected AuthenticatorConfigModel getAuthenticatorConfig(AuthenticationFlowContext context) {
                return DeployedScriptAuthenticatorFactory.this.model;
            }
        };
    }

    @Override
    public String getId() {
        return this.model.getId();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    @Override
    public String getDisplayType() {
        return this.model.getAlias();
    }

    @Override
    public String getHelpText() {
        return this.model.getAlias();
    }

    @Override
    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }
}

