/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.timer.ScheduledTask;

public class ClearExpiredUserSessions
implements ScheduledTask {
    public static final String TASK_NAME = "ClearExpiredUserSessions";

    public void run(KeycloakSession session) {
        UserSessionProvider sessions = session.sessions();
        for (RealmModel realm : session.realms().getRealms()) {
            sessions.removeExpired(realm);
            session.authenticationSessions().removeExpired(realm);
            ((UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class)).removeExpired(realm);
        }
    }
}

