/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.FilesPlainTextVaultProvider;
import org.keycloak.vault.VaultNotFoundException;
import org.keycloak.vault.VaultProvider;

public class FilesPlainTextVaultProviderFactory
extends AbstractVaultProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROVIDER_ID = "files-plaintext";
    private String vaultDirectory;
    private Path vaultPath;

    public VaultProvider create(KeycloakSession session) {
        if (this.vaultDirectory == null) {
            logger.debug((Object)"Can not create a vault since it's not initialized correctly");
            return null;
        }
        return new FilesPlainTextVaultProvider(this.vaultPath, this.getRealmName(session), this.keyResolvers);
    }

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        this.vaultDirectory = config.get("dir");
        if (this.vaultDirectory == null) {
            logger.debug((Object)"PlainTextVaultProviderFactory not configured");
            return;
        }
        this.vaultPath = Paths.get(this.vaultDirectory, new String[0]);
        if (!Files.exists(this.vaultPath, new LinkOption[0])) {
            throw new VaultNotFoundException("The " + this.vaultPath.toAbsolutePath().toString() + " directory doesn't exist");
        }
        logger.debugf("Configured PlainTextVaultProviderFactory with directory %s", (Object)this.vaultPath.toString());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

