"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "../../@patternfly/patternfly/components/Form/form.css.js", "../../helpers/htmlConstants", "./FormContext", "@patternfly/react-styles"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("../../@patternfly/patternfly/components/Form/form.css.js"), require("../../helpers/htmlConstants"), require("./FormContext"), require("@patternfly/react-styles"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.formCss, global.htmlConstants, global.FormContext, global.reactStyles);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _formCss, _htmlConstants, _FormContext, _reactStyles) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.FormGroup = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _formCss2 = _interopRequireDefault(_formCss);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var FormGroup = exports.FormGroup = function FormGroup(_ref) {
    var _ref$children = _ref.children,
        children = _ref$children === void 0 ? null : _ref$children,
        _ref$className = _ref.className,
        className = _ref$className === void 0 ? '' : _ref$className,
        label = _ref.label,
        _ref$isRequired = _ref.isRequired,
        isRequired = _ref$isRequired === void 0 ? false : _ref$isRequired,
        _ref$isValid = _ref.isValid,
        isValid = _ref$isValid === void 0 ? true : _ref$isValid,
        _ref$isInline = _ref.isInline,
        isInline = _ref$isInline === void 0 ? false : _ref$isInline,
        helperText = _ref.helperText,
        helperTextInvalid = _ref.helperTextInvalid,
        fieldId = _ref.fieldId,
        props = _objectWithoutProperties(_ref, ["children", "className", "label", "isRequired", "isValid", "isInline", "helperText", "helperTextInvalid", "fieldId"]);

    return React.createElement(_FormContext.FormContext.Consumer, null, function (_ref2) {
      var isHorizontal = _ref2.isHorizontal;
      return React.createElement("div", _extends({}, props, {
        className: (0, _reactStyles.css)(_formCss2["default"].formGroup, isInline ? (0, _reactStyles.getModifier)(_formCss2["default"], 'inline', className) : '')
      }), label && React.createElement("label", {
        className: (0, _reactStyles.css)(_formCss2["default"].formLabel),
        htmlFor: fieldId
      }, label, isRequired && React.createElement("span", {
        className: (0, _reactStyles.css)(_formCss2["default"].formLabelRequired),
        "aria-hidden": "true"
      }, _htmlConstants.ASTERISK)), isHorizontal ? React.createElement("div", {
        className: (0, _reactStyles.css)(_formCss2["default"].formHorizontalGroup)
      }, children) : children, (isValid && helperText || !isValid && helperTextInvalid) && React.createElement("div", {
        className: (0, _reactStyles.css)(_formCss2["default"].formHelperText, !isValid ? (0, _reactStyles.getModifier)(_formCss2["default"], 'error') : ''),
        id: "".concat(fieldId, "-helper"),
        "aria-live": "polite"
      }, isValid ? helperText : helperTextInvalid));
    });
  };

  FormGroup.propTypes = {
    children: _propTypes2["default"].node,
    className: _propTypes2["default"].string,
    label: _propTypes2["default"].node,
    isRequired: _propTypes2["default"].bool,
    isValid: _propTypes2["default"].bool,
    isInline: _propTypes2["default"].bool,
    helperText: _propTypes2["default"].node,
    helperTextInvalid: _propTypes2["default"].node,
    fieldId: _propTypes2["default"].string.isRequired
  };
});