/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.encoding;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Version;
import org.keycloak.encoding.GzipResourceEncodingProvider;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.encoding.ResourceEncodingProviderFactory;
import org.keycloak.models.KeycloakSession;

public class GzipResourceEncodingProviderFactory
implements ResourceEncodingProviderFactory {
    private static final Logger logger = Logger.getLogger(GzipResourceEncodingProviderFactory.class);
    private Set<String> excludedContentTypes = new HashSet<String>();
    private File cacheDir;

    public ResourceEncodingProvider create(KeycloakSession session) {
        if (this.cacheDir == null) {
            this.cacheDir = this.initCacheDir();
        }
        return new GzipResourceEncodingProvider(session, this.cacheDir);
    }

    @Override
    public void init(Config.Scope config) {
        String e = config.get("excludedContentTypes", "image/png image/jpeg");
        for (String s : e.split(" ")) {
            this.excludedContentTypes.add(s);
        }
    }

    @Override
    public boolean encodeContentType(String contentType) {
        return !this.excludedContentTypes.contains(contentType);
    }

    public String getId() {
        return "gzip";
    }

    private synchronized File initCacheDir() {
        if (this.cacheDir != null) {
            return this.cacheDir;
        }
        File cacheRoot = new File(System.getProperty("java.io.tmpdir"), "kc-gzip-cache");
        File cacheDir = new File(cacheRoot, Version.RESOURCES_VERSION);
        if (cacheRoot.isDirectory()) {
            for (File f : cacheRoot.listFiles()) {
                if (f.getName().equals(Version.RESOURCES_VERSION)) continue;
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to delete old gzip cache directory", (Throwable)e);
                }
            }
        }
        if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
            logger.warn((Object)"Failed to create gzip cache directory");
            return null;
        }
        return cacheDir;
    }
}

