/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenResponseMapper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.services.ServicesLogger;
import org.keycloak.util.JsonSerialization;

public class OIDCAttributeMapperHelper {
    public static final String TOKEN_CLAIM_NAME = "claim.name";
    public static final String TOKEN_CLAIM_NAME_LABEL = "tokenClaimName.label";
    public static final String TOKEN_CLAIM_NAME_TOOLTIP = "tokenClaimName.tooltip";
    public static final String JSON_TYPE = "jsonType.label";
    public static final String JSON_TYPE_TOOLTIP = "jsonType.tooltip";
    public static final String INCLUDE_IN_ACCESS_TOKEN = "access.token.claim";
    public static final String INCLUDE_IN_ACCESS_TOKEN_LABEL = "includeInAccessToken.label";
    public static final String INCLUDE_IN_ACCESS_TOKEN_HELP_TEXT = "includeInAccessToken.tooltip";
    public static final String INCLUDE_IN_ID_TOKEN = "id.token.claim";
    public static final String INCLUDE_IN_ID_TOKEN_LABEL = "includeInIdToken.label";
    public static final String INCLUDE_IN_ID_TOKEN_HELP_TEXT = "includeInIdToken.tooltip";
    public static final String INCLUDE_IN_ACCESS_TOKEN_RESPONSE = "access.tokenResponse.claim";
    public static final String INCLUDE_IN_ACCESS_TOKEN_RESPONSE_LABEL = "includeInAccessTokenResponse.label";
    public static final String INCLUDE_IN_ACCESS_TOKEN_RESPONSE_HELP_TEXT = "includeInAccessTokenResponse.tooltip";
    public static final String INCLUDE_IN_USERINFO = "userinfo.token.claim";
    public static final String INCLUDE_IN_USERINFO_LABEL = "includeInUserInfo.label";
    public static final String INCLUDE_IN_USERINFO_HELP_TEXT = "includeInUserInfo.tooltip";
    private static final Pattern CLAIM_COMPONENT = Pattern.compile("^((\\\\.|[^\\\\.])+?)\\.");
    private static final Pattern BACKSLASHED_CHARACTER = Pattern.compile("\\\\(.)");

    public static Object mapAttributeValue(ProtocolMapperModel mappingModel, Object attributeValue) {
        String type;
        Object converted;
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof Collection) {
            Collection valueAsList = (Collection)attributeValue;
            if (valueAsList.isEmpty()) {
                return null;
            }
            if (OIDCAttributeMapperHelper.isMultivalued(mappingModel)) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object valueItem : valueAsList) {
                    result.add(OIDCAttributeMapperHelper.mapAttributeValue(mappingModel, valueItem));
                }
                return result;
            }
            if (valueAsList.size() > 1) {
                ServicesLogger.LOGGER.multipleValuesForMapper(attributeValue.toString(), mappingModel.getName());
            }
            attributeValue = valueAsList.iterator().next();
        }
        return (converted = OIDCAttributeMapperHelper.convertToType(type = (String)mappingModel.getConfig().get(JSON_TYPE), attributeValue)) != null ? converted : attributeValue;
    }

    private static <X, T> List<T> transform(List<X> attributeValue, Function<X, T> mapper) {
        return attributeValue.stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    private static Object convertToType(String type, Object attributeValue) {
        if (type == null || attributeValue == null) {
            return attributeValue;
        }
        switch (type) {
            case "boolean": {
                Boolean booleanObject = OIDCAttributeMapperHelper.getBoolean(attributeValue);
                if (booleanObject != null) {
                    return booleanObject;
                }
                if (attributeValue instanceof List) {
                    return OIDCAttributeMapperHelper.transform((List)attributeValue, OIDCAttributeMapperHelper::getBoolean);
                }
                throw new RuntimeException("cannot map type for token claim");
            }
            case "String": {
                if (attributeValue instanceof String) {
                    return attributeValue;
                }
                if (attributeValue instanceof List) {
                    return OIDCAttributeMapperHelper.transform((List)attributeValue, OIDCAttributeMapperHelper::getString);
                }
                return attributeValue.toString();
            }
            case "long": {
                Long longObject = OIDCAttributeMapperHelper.getLong(attributeValue);
                if (longObject != null) {
                    return longObject;
                }
                if (attributeValue instanceof List) {
                    return OIDCAttributeMapperHelper.transform((List)attributeValue, OIDCAttributeMapperHelper::getLong);
                }
                throw new RuntimeException("cannot map type for token claim");
            }
            case "int": {
                Integer intObject = OIDCAttributeMapperHelper.getInteger(attributeValue);
                if (intObject != null) {
                    return intObject;
                }
                if (attributeValue instanceof List) {
                    return OIDCAttributeMapperHelper.transform((List)attributeValue, OIDCAttributeMapperHelper::getInteger);
                }
                throw new RuntimeException("cannot map type for token claim");
            }
            case "JSON": {
                JsonNode jsonNodeObject = OIDCAttributeMapperHelper.getJsonNode(attributeValue);
                if (jsonNodeObject != null) {
                    return jsonNodeObject;
                }
                if (attributeValue instanceof List) {
                    return OIDCAttributeMapperHelper.transform((List)attributeValue, OIDCAttributeMapperHelper::getJsonNode);
                }
                throw new RuntimeException("cannot map type for token claim");
            }
        }
        return null;
    }

    private static String getString(Object attributeValue) {
        return attributeValue.toString();
    }

    private static Long getLong(Object attributeValue) {
        if (attributeValue instanceof Long) {
            return (Long)attributeValue;
        }
        if (attributeValue instanceof String) {
            return Long.valueOf((String)attributeValue);
        }
        return null;
    }

    private static Integer getInteger(Object attributeValue) {
        if (attributeValue instanceof Integer) {
            return (Integer)attributeValue;
        }
        if (attributeValue instanceof String) {
            return Integer.valueOf((String)attributeValue);
        }
        return null;
    }

    private static Boolean getBoolean(Object attributeValue) {
        if (attributeValue instanceof Boolean) {
            return (Boolean)attributeValue;
        }
        if (attributeValue instanceof String) {
            return Boolean.valueOf((String)attributeValue);
        }
        return null;
    }

    private static JsonNode getJsonNode(Object attributeValue) {
        if (attributeValue instanceof JsonNode) {
            return (JsonNode)attributeValue;
        }
        if (attributeValue instanceof String) {
            try {
                return (JsonNode)JsonSerialization.readValue((String)attributeValue.toString(), JsonNode.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<String> splitClaimPath(String claimPath) {
        LinkedList<String> claimComponents = new LinkedList<String>();
        Matcher m = CLAIM_COMPONENT.matcher(claimPath);
        int start = 0;
        while (m.find()) {
            claimComponents.add(BACKSLASHED_CHARACTER.matcher(m.group(1)).replaceAll("$1"));
            start = m.end();
            m.region(start, claimPath.length());
        }
        if (claimPath.length() > start) {
            claimComponents.add(BACKSLASHED_CHARACTER.matcher(claimPath.substring(start)).replaceAll("$1"));
        }
        return claimComponents;
    }

    public static void mapClaim(IDToken token, ProtocolMapperModel mappingModel, Object attributeValue) {
        OIDCAttributeMapperHelper.mapClaim(mappingModel, attributeValue, token.getOtherClaims());
    }

    public static void mapClaim(AccessTokenResponse token, ProtocolMapperModel mappingModel, Object attributeValue) {
        OIDCAttributeMapperHelper.mapClaim(mappingModel, attributeValue, token.getOtherClaims());
    }

    private static void mapClaim(ProtocolMapperModel mappingModel, Object attributeValue, Map<String, Object> jsonObject) {
        if ((attributeValue = OIDCAttributeMapperHelper.mapAttributeValue(mappingModel, attributeValue)) == null) {
            return;
        }
        String protocolClaim = (String)mappingModel.getConfig().get(TOKEN_CLAIM_NAME);
        if (protocolClaim == null) {
            return;
        }
        List<String> split = OIDCAttributeMapperHelper.splitClaimPath(protocolClaim);
        int length = split.size();
        int i = 0;
        for (String component : split) {
            if (++i == length) {
                jsonObject.put(component, attributeValue);
                continue;
            }
            HashMap<String, Object> nested = (HashMap<String, Object>)jsonObject.get(component);
            if (nested == null) {
                nested = new HashMap<String, Object>();
                jsonObject.put(component, nested);
            }
            jsonObject = nested;
        }
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, String mapperId) {
        return OIDCAttributeMapperHelper.createClaimMapper(name, userAttribute, tokenClaimName, claimType, accessToken, idToken, true, mapperId);
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean userinfo, String mapperId) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(mapperId);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("user.attribute", userAttribute);
        config.put(TOKEN_CLAIM_NAME, tokenClaimName);
        config.put(JSON_TYPE, claimType);
        if (accessToken) {
            config.put(INCLUDE_IN_ACCESS_TOKEN, "true");
        }
        if (idToken) {
            config.put(INCLUDE_IN_ID_TOKEN, "true");
        }
        if (userinfo) {
            config.put(INCLUDE_IN_USERINFO, "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    public static boolean includeInIDToken(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get(INCLUDE_IN_ID_TOKEN));
    }

    public static boolean includeInAccessToken(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get(INCLUDE_IN_ACCESS_TOKEN));
    }

    public static boolean includeInAccessTokenResponse(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get(INCLUDE_IN_ACCESS_TOKEN_RESPONSE));
    }

    public static boolean isMultivalued(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get("multivalued"));
    }

    public static boolean includeInUserInfo(ProtocolMapperModel mappingModel) {
        String includeInUserInfo = (String)mappingModel.getConfig().get(INCLUDE_IN_USERINFO);
        if (includeInUserInfo == null && OIDCAttributeMapperHelper.includeInIDToken(mappingModel)) {
            return true;
        }
        return "true".equals(includeInUserInfo);
    }

    public static void addAttributeConfig(List<ProviderConfigProperty> configProperties, Class<? extends ProtocolMapper> protocolMapperClass) {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        OIDCAttributeMapperHelper.addJsonTypeConfig(configProperties);
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, protocolMapperClass);
    }

    public static void addTokenClaimNameConfig(List<ProviderConfigProperty> configProperties) {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(TOKEN_CLAIM_NAME);
        property.setLabel(TOKEN_CLAIM_NAME_LABEL);
        property.setType("String");
        property.setHelpText(TOKEN_CLAIM_NAME_TOOLTIP);
        configProperties.add(property);
    }

    public static void addJsonTypeConfig(List<ProviderConfigProperty> configProperties) {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(JSON_TYPE);
        property.setLabel(JSON_TYPE);
        ArrayList<String> types = new ArrayList<String>(5);
        types.add("String");
        types.add("long");
        types.add("int");
        types.add("boolean");
        types.add("JSON");
        property.setType("List");
        property.setOptions(types);
        property.setHelpText(JSON_TYPE_TOOLTIP);
        configProperties.add(property);
    }

    public static void addIncludeInTokensConfig(List<ProviderConfigProperty> configProperties, Class<? extends ProtocolMapper> protocolMapperClass) {
        ProviderConfigProperty property;
        if (OIDCIDTokenMapper.class.isAssignableFrom(protocolMapperClass)) {
            property = new ProviderConfigProperty();
            property.setName(INCLUDE_IN_ID_TOKEN);
            property.setLabel(INCLUDE_IN_ID_TOKEN_LABEL);
            property.setType("boolean");
            property.setDefaultValue((Object)"true");
            property.setHelpText(INCLUDE_IN_ID_TOKEN_HELP_TEXT);
            configProperties.add(property);
        }
        if (OIDCAccessTokenMapper.class.isAssignableFrom(protocolMapperClass)) {
            property = new ProviderConfigProperty();
            property.setName(INCLUDE_IN_ACCESS_TOKEN);
            property.setLabel(INCLUDE_IN_ACCESS_TOKEN_LABEL);
            property.setType("boolean");
            property.setDefaultValue((Object)"true");
            property.setHelpText(INCLUDE_IN_ACCESS_TOKEN_HELP_TEXT);
            configProperties.add(property);
        }
        if (UserInfoTokenMapper.class.isAssignableFrom(protocolMapperClass)) {
            property = new ProviderConfigProperty();
            property.setName(INCLUDE_IN_USERINFO);
            property.setLabel(INCLUDE_IN_USERINFO_LABEL);
            property.setType("boolean");
            property.setDefaultValue((Object)"true");
            property.setHelpText(INCLUDE_IN_USERINFO_HELP_TEXT);
            configProperties.add(property);
        }
        if (OIDCAccessTokenResponseMapper.class.isAssignableFrom(protocolMapperClass)) {
            property = new ProviderConfigProperty();
            property.setName(INCLUDE_IN_ACCESS_TOKEN_RESPONSE);
            property.setLabel(INCLUDE_IN_ACCESS_TOKEN_RESPONSE_LABEL);
            property.setType("boolean");
            property.setDefaultValue((Object)"false");
            property.setHelpText(INCLUDE_IN_ACCESS_TOKEN_RESPONSE_HELP_TEXT);
            configProperties.add(property);
        }
    }
}

