/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientUpdateContext;
import org.keycloak.services.resources.admin.AdminAuth;

public class AdminClientRegisterContext
implements ClientUpdateContext {
    private final ClientRepresentation clientRepresentation;
    private final AdminAuth adminAuth;

    public AdminClientRegisterContext(ClientRepresentation clientRepresentation, AdminAuth adminAuth) {
        this.clientRepresentation = clientRepresentation;
        this.adminAuth = adminAuth;
    }

    public ClientPolicyEvent getEvent() {
        return ClientPolicyEvent.REGISTER;
    }

    @Override
    public ClientRepresentation getProposedClientRepresentation() {
        return this.clientRepresentation;
    }

    @Override
    public ClientModel getAuthenticatedClient() {
        return this.adminAuth.getClient();
    }

    @Override
    public UserModel getAuthenticatedUser() {
        return this.adminAuth.getUser();
    }

    @Override
    public JsonWebToken getToken() {
        return this.adminAuth.getToken();
    }
}

