/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.services.clientpolicy.ClientPolicyProvider;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class DefaultClientPolicyManager
implements ClientPolicyManager {
    private static final Logger logger = Logger.getLogger(DefaultClientPolicyManager.class);
    private final KeycloakSession session;
    private final Map<String, List<ClientPolicyProvider>> providersMap = new HashMap<String, List<ClientPolicyProvider>>();

    public DefaultClientPolicyManager(KeycloakSession session) {
        this.session = session;
    }

    public void triggerOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_POLICIES)) {
            return;
        }
        ClientPolicyLogger.logv(logger, "Client Policy Operation : event = {0}", context.getEvent());
        this.doPolicyOperation(condition -> condition.applyPolicy(context), executor -> executor.executeOnEvent(context));
    }

    private void doPolicyOperation(ClientConditionOperation condition, ClientExecutorOperation executor) throws ClientPolicyException {
        RealmModel realm = this.session.getContext().getRealm();
        for (ClientPolicyProvider policy : this.getProviders(realm)) {
            ClientPolicyLogger.logv(logger, "Policy Operation : name = {0}, provider id = {1}", policy.getName(), policy.getProviderId());
            if (!this.isSatisfied(policy, condition)) continue;
            this.execute(policy, executor);
        }
    }

    private List<ClientPolicyProvider> getProviders(RealmModel realm) {
        List<Object> providers = this.providersMap.get(realm.getId());
        if (providers == null) {
            providers = realm.getComponentsStream(realm.getId(), ClientPolicyProvider.class.getName()).map(policyModel -> {
                try {
                    ClientPolicyProvider policy = (ClientPolicyProvider)this.session.getProvider(ClientPolicyProvider.class, policyModel);
                    ClientPolicyLogger.logv(logger, "Loaded Policy Name = {0}", policyModel.getName());
                    this.session.enlistForClose((Provider)policy);
                    return policy;
                }
                catch (Throwable t) {
                    logger.errorv(t, "Failed to load provider {0}", (Object)policyModel.getId());
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.providersMap.put(realm.getId(), providers);
        } else {
            ClientPolicyLogger.log(logger, "Use cached policies.");
        }
        return providers;
    }

    private boolean isSatisfied(ClientPolicyProvider policy, ClientConditionOperation op) throws ClientPolicyException {
        List conditions = policy.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            ClientPolicyLogger.log(logger, "NEGATIVE :: This policy is not applied. No condition exists.");
            return false;
        }
        boolean ret = false;
        for (ClientPolicyConditionProvider condition : conditions) {
            try {
                ClientPolicyVote vote = op.run(condition);
                if (vote == ClientPolicyVote.ABSTAIN) {
                    ClientPolicyLogger.logv(logger, "SKIP : This condition is not evaluated due to its nature. name = {0}, provider id = {1}", condition.getName(), condition.getProviderId());
                    continue;
                }
                if (vote == ClientPolicyVote.NO) {
                    ClientPolicyLogger.logv(logger, "NEGATIVE :: This policy is not applied. condition not satisfied. name = {0}, provider id = {1}, ", condition.getName(), condition.getProviderId());
                    return false;
                }
                ret = true;
            }
            catch (ClientPolicyException cpe) {
                ClientPolicyLogger.logv(logger, "CONDITION EXCEPTION : name = {0}, provider id = {1}, error = {2}, error_detail = {3}", condition.getName(), condition.getProviderId(), cpe.getError(), cpe.getErrorDetail());
                throw cpe;
            }
        }
        if (ret) {
            ClientPolicyLogger.log(logger, "POSITIVE :: This policy is applied.");
        } else {
            ClientPolicyLogger.log(logger, "NEGATIVE :: This policy is not applied. No condition is evaluated.");
        }
        return ret;
    }

    private void execute(ClientPolicyProvider policy, ClientExecutorOperation op) throws ClientPolicyException {
        List executors = policy.getExecutors();
        if (executors == null || executors.isEmpty()) {
            ClientPolicyLogger.log(logger, "NEGATIVE :: This executor is not executed. No executor executable.");
            return;
        }
        for (ClientPolicyExecutorProvider executor : executors) {
            try {
                op.run(executor);
            }
            catch (ClientPolicyException cpe) {
                ClientPolicyLogger.logv(logger, "EXECUTOR EXCEPTION : name = {0}, provider id = {1}, error = {2}, error_detail = {3}", executor.getName(), executor.getProviderId(), cpe.getError(), cpe.getErrorDetail());
                throw cpe;
            }
        }
    }

    private static interface ClientExecutorOperation {
        public void run(ClientPolicyExecutorProvider var1) throws ClientPolicyException;
    }

    private static interface ClientConditionOperation {
        public ClientPolicyVote run(ClientPolicyConditionProvider var1) throws ClientPolicyException;
    }
}

