/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.clientpolicy.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.ClientUpdateContext;
import org.keycloak.services.clientpolicy.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientUpdateSourceGroupsCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientUpdateSourceGroupsCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientUpdateSourceGroupsCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    return this.getVoteForGroupsMatched(((ClientUpdateContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientRegisterContext) {
                    return this.getVoteForGroupsMatched(((ClientUpdateContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    return this.getVoteForGroupsMatched(((ClientUpdateContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientUpdateContext) {
                    return this.getVoteForGroupsMatched(((ClientUpdateContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private ClientPolicyVote getVoteForGroupsMatched(UserModel user) {
        if (this.isGroupsMatched(user)) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private ClientPolicyVote getVoteForGroupsMatched(JsonWebToken token) {
        if (token == null) {
            return ClientPolicyVote.NO;
        }
        if (this.isGroupMatched(token.getSubject())) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private boolean isGroupMatched(String subjectId) {
        if (subjectId == null) {
            return false;
        }
        return this.isGroupsMatched(this.session.users().getUserById(subjectId, this.session.getContext().getRealm()));
    }

    private boolean isGroupsMatched(UserModel user) {
        boolean isMatched;
        if (user == null) {
            return false;
        }
        Set<String> expectedGroups = this.instantiateGroupsForMatching();
        if (expectedGroups == null) {
            return false;
        }
        Set groups = user.getGroupsStream().map(GroupModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            groups.stream().forEach(i -> ClientPolicyLogger.log(logger, " user group = " + i));
            expectedGroups.stream().forEach(i -> ClientPolicyLogger.log(logger, "groups expected = " + i));
        }
        if (isMatched = expectedGroups.removeAll(groups)) {
            ClientPolicyLogger.log(logger, "group matched.");
        } else {
            ClientPolicyLogger.log(logger, "group unmatched.");
        }
        return isMatched;
    }

    private Set<String> instantiateGroupsForMatching() {
        if (this.componentModel.getConfig() == null) {
            return null;
        }
        List roles = (List)this.componentModel.getConfig().get((Object)"groups");
        if (roles == null) {
            return null;
        }
        return new HashSet<String>(roles);
    }
}

