/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.clientpolicy.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.ClientUpdateContext;
import org.keycloak.services.clientpolicy.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientUpdateSourceRolesCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientUpdateSourceRolesCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientUpdateSourceRolesCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    return this.getVoteForRolesMatched(((ClientUpdateContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientRegisterContext) {
                    return this.getVoteForRolesMatched(((ClientUpdateContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    return this.getVoteForRolesMatched(((ClientUpdateContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientUpdateContext) {
                    return this.getVoteForRolesMatched(((ClientUpdateContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private ClientPolicyVote getVoteForRolesMatched(UserModel user) {
        if (this.isRolesMatched(user)) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private ClientPolicyVote getVoteForRolesMatched(JsonWebToken token) {
        if (token == null) {
            return ClientPolicyVote.NO;
        }
        if (this.isRoleMatched(token.getSubject())) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private boolean isRoleMatched(String subjectId) {
        if (subjectId == null) {
            return false;
        }
        return this.isRolesMatched(this.session.users().getUserById(subjectId, this.session.getContext().getRealm()));
    }

    private boolean isRolesMatched(UserModel user) {
        if (user == null) {
            return false;
        }
        Set<String> expectedRoles = this.instantiateRolesForMatching();
        if (expectedRoles == null) {
            return false;
        }
        Set roles = user.getRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            roles.stream().forEach(i -> ClientPolicyLogger.log(logger, " user role = " + i));
            expectedRoles.stream().forEach(i -> ClientPolicyLogger.log(logger, "roles expected = " + i));
        }
        RealmModel realm = this.session.getContext().getRealm();
        boolean isMatched = expectedRoles.stream().anyMatch(i -> {
            if (realm.getRole(i) != null && user.hasRole(realm.getRole(i))) {
                return true;
            }
            return realm.getClientsStream().anyMatch(j -> j.getRole(i) != null && user.hasRole(j.getRole(i)));
        });
        if (isMatched) {
            ClientPolicyLogger.log(logger, "role matched.");
        } else {
            ClientPolicyLogger.log(logger, "role unmatched.");
        }
        return isMatched;
    }

    private Set<String> instantiateRolesForMatching() {
        if (this.componentModel.getConfig() == null) {
            return null;
        }
        List roles = (List)this.componentModel.getConfig().get((Object)"roles");
        if (roles == null) {
            return null;
        }
        return new HashSet<String>(roles);
    }
}

