/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.AbstractAugumentingClientRegistrationPolicyExecutorFactory;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.SecureClientAuthEnforceExecutor;

public class SecureClientAuthEnforceExecutorFactory
extends AbstractAugumentingClientRegistrationPolicyExecutorFactory {
    public static final String PROVIDER_ID = "secure-client-authn-executor";
    public static final String CLIENT_AUTHNS = "client-authns";
    public static final String CLIENT_AUTHNS_AUGMENT = "client-authns-augment";
    private static final ProviderConfigProperty CLIENTAUTHNS_PROPERTY = new ProviderConfigProperty("client-authns", null, null, "MultivaluedString", null);
    private static final ProviderConfigProperty CLIENTAUTHNS_AUGMENT = new ProviderConfigProperty("client-authns-augment", null, null, "String", (Object)"client-jwt");

    public ClientPolicyExecutorProvider create(KeycloakSession session, ComponentModel model) {
        return new SecureClientAuthEnforceExecutor(session, model);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It makes the client enforce registering/updating secure client authentication.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        List<ProviderConfigProperty> l = super.getConfigProperties();
        l.add(CLIENTAUTHNS_PROPERTY);
        l.add(CLIENTAUTHNS_AUGMENT);
        return l;
    }
}

