/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.execactions.ExecuteActionsActionToken;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.validation.Validation;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.profile.DefaultUserProfileContext;
import org.keycloak.userprofile.profile.representations.UserRepresentationUserProfile;
import org.keycloak.userprofile.utils.UserUpdateHelper;
import org.keycloak.userprofile.validation.AttributeValidationResult;
import org.keycloak.userprofile.validation.UserProfileValidationResult;
import org.keycloak.userprofile.validation.ValidationResult;
import org.keycloak.utils.ProfileHelper;

public class UserResource {
    private static final Logger logger = Logger.getLogger(UserResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    private UserModel user;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UserResource(RealmModel realm, UserModel user, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.user = user;
        this.adminEvent = adminEvent.resource(ResourceType.USER);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateUser(UserRepresentation rep) {
        this.auth.users().requireManage(this.user);
        try {
            Response response;
            UserLoginFailureModel failureModel;
            if (rep.isEnabled() != null && rep.isEnabled().booleanValue() && (failureModel = this.session.sessions().getUserLoginFailure(this.realm, this.user.getId())) != null) {
                failureModel.clearFailures();
            }
            if ((response = UserResource.validateUserProfile(this.user, rep, this.session)) != null) {
                return response;
            }
            UserResource.updateUserFromRep(this.user, rep, this.session, true);
            RepresentationToModel.createCredentials((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)this.user, (boolean)true);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("User exists with same username or email");
        }
        catch (ReadOnlyException re) {
            return ErrorResponse.exists("User is read only!");
        }
        catch (ModelException me) {
            logger.warn((Object)"Could not update user!", (Throwable)me);
            return ErrorResponse.error("Could not update user!", Response.Status.BAD_REQUEST);
        }
        catch (ForbiddenException fe) {
            throw fe;
        }
        catch (Exception me) {
            logger.warn((Object)"Could not update user!", (Throwable)me);
            return ErrorResponse.error("Could not update user!", Response.Status.BAD_REQUEST);
        }
    }

    public static Response validateUserProfile(UserModel user, UserRepresentation rep, KeycloakSession session) {
        UserRepresentationUserProfile updatedUser = new UserRepresentationUserProfile(rep);
        UserProfileProvider profileProvider = (UserProfileProvider)session.getProvider(UserProfileProvider.class, "legacy-user-profile");
        UserProfileValidationResult result = profileProvider.validate((UserProfileContext)DefaultUserProfileContext.forUserResource(user), (UserProfile)updatedUser);
        if (!result.getErrors().isEmpty()) {
            for (AttributeValidationResult attrValidation : result.getErrors()) {
                StringBuilder s = new StringBuilder("Failed to update attribute " + attrValidation.getField() + ": ");
                for (ValidationResult valResult : attrValidation.getFailedValidations()) {
                    s.append(valResult.getErrorType() + ", ");
                }
                logger.warn((Object)s);
            }
            return ErrorResponse.error("Could not update user! See server log for more details", Response.Status.BAD_REQUEST);
        }
        return null;
    }

    public static void updateUserFromRep(UserModel user, UserRepresentation rep, KeycloakSession session, boolean isUpdateExistingUser) {
        List credentials;
        List reqActions;
        boolean removeMissingRequiredActions = isUpdateExistingUser;
        UserUpdateHelper.updateUserResource(session.getContext().getRealm(), user, new UserRepresentationUserProfile(rep), isUpdateExistingUser);
        if (rep.isEnabled() != null) {
            user.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isEmailVerified() != null) {
            user.setEmailVerified(rep.isEmailVerified().booleanValue());
        }
        if (rep.getFederationLink() != null) {
            user.setFederationLink(rep.getFederationLink());
        }
        if ((reqActions = rep.getRequiredActions()) != null) {
            HashSet<String> allActions = new HashSet<String>();
            for (ProviderFactory factory : session.getKeycloakSessionFactory().getProviderFactories(RequiredActionProvider.class)) {
                allActions.add(factory.getId());
            }
            for (String action : allActions) {
                if (reqActions.contains(action)) {
                    user.addRequiredAction(action);
                    continue;
                }
                if (!removeMissingRequiredActions) continue;
                user.removeRequiredAction(action);
            }
        }
        if ((credentials = rep.getCredentials()) != null) {
            for (CredentialRepresentation credential : credentials) {
                if (!"password".equals(credential.getType()) || credential.isTemporary() == null || !credential.isTemporary().booleanValue()) continue;
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
            }
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getUser() {
        this.auth.users().requireView(this.user);
        UserRepresentation rep = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)this.user);
        if (this.realm.isIdentityFederationEnabled()) {
            List reps = this.getFederatedIdentities(this.user).collect(Collectors.toList());
            rep.setFederatedIdentities(reps);
        }
        if (((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, this.user)) {
            rep.setEnabled(Boolean.valueOf(false));
        }
        rep.setAccess(this.auth.users().getAccess(this.user));
        return rep;
    }

    @Path(value="impersonation")
    @POST
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Object> impersonate() {
        ProfileHelper.requireFeature(Profile.Feature.IMPERSONATION);
        this.auth.users().requireImpersonate(this.user);
        RealmModel authenticatedRealm = this.auth.adminAuth().getRealm();
        boolean sameRealm = false;
        if (authenticatedRealm.getId().equals(this.realm.getId())) {
            sameRealm = true;
            UserSessionModel userSession = this.session.sessions().getUserSession(authenticatedRealm, this.auth.adminAuth().getToken().getSessionState());
            AuthenticationManager.expireIdentityCookie(this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
            AuthenticationManager.expireRememberMeCookie(this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
            AuthenticationManager.backchannelLogout(this.session, authenticatedRealm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true);
        }
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, this.user, this.user.getUsername(), this.clientConnection.getRemoteAddr(), "impersonate", false, null, null);
        UserModel adminUser = this.auth.adminAuth().getUser();
        String impersonatorId = adminUser.getId();
        String impersonator = adminUser.getUsername();
        userSession.setNote(ImpersonationSessionNote.IMPERSONATOR_ID.toString(), impersonatorId);
        userSession.setNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString(), impersonator);
        AuthenticationManager.createLoginCookie(this.session, this.realm, userSession.getUser(), userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
        URI redirect = AccountFormService.accountServiceBaseUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sameRealm", sameRealm);
        result.put("redirect", redirect.toString());
        event.event(EventType.IMPERSONATE).session(userSession).user(this.user).detail("impersonator_realm", authenticatedRealm.getName()).detail("impersonator", impersonator).success();
        return result;
    }

    @Path(value="sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<UserSessionRepresentation> getSessions() {
        this.auth.users().requireView(this.user);
        return this.session.sessions().getUserSessionsStream(this.realm, this.user).map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="offline-sessions/{clientUuid}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<UserSessionRepresentation> getOfflineSessions(@PathParam(value="clientUuid") String clientUuid) {
        this.auth.users().requireView(this.user);
        ClientModel client = this.realm.getClientById(clientUuid);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        return new UserSessionManager(this.session).findOfflineSessionsStream(this.realm, this.user).map(session -> this.toUserSessionRepresentation((UserSessionModel)session, clientUuid)).filter(Objects::nonNull);
    }

    @Path(value="federated-identity")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<FederatedIdentityRepresentation> getFederatedIdentity() {
        this.auth.users().requireView(this.user);
        return this.getFederatedIdentities(this.user);
    }

    private Stream<FederatedIdentityRepresentation> getFederatedIdentities(UserModel user) {
        Set idps = this.realm.getIdentityProvidersStream().map(IdentityProviderModel::getAlias).collect(Collectors.toSet());
        return this.session.users().getFederatedIdentitiesStream(user, this.realm).filter(identity -> idps.contains(identity.getIdentityProvider())).map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="federated-identity/{provider}")
    @POST
    @NoCache
    public Response addFederatedIdentity(@PathParam(value="provider") String provider, FederatedIdentityRepresentation rep) {
        this.auth.users().requireManage(this.user);
        if (this.session.users().getFederatedIdentity(this.user, provider, this.realm) != null) {
            return ErrorResponse.exists("User is already linked with provider");
        }
        FederatedIdentityModel socialLink = new FederatedIdentityModel(provider, rep.getUserId(), rep.getUserName());
        this.session.users().addFederatedIdentity(this.realm, this.user, socialLink);
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return Response.noContent().build();
    }

    @Path(value="federated-identity/{provider}")
    @DELETE
    @NoCache
    public void removeFederatedIdentity(@PathParam(value="provider") String provider) {
        this.auth.users().requireManage(this.user);
        if (!this.session.users().removeFederatedIdentity(this.realm, this.user, provider)) {
            throw new NotFoundException("Link not found");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="consents")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<Map<String, Object>> getConsents() {
        this.auth.users().requireView(this.user);
        Set<ClientModel> offlineClients = new UserSessionManager(this.session).findClientsWithOfflineToken(this.realm, this.user);
        return this.realm.getClientsStream().map(client -> this.toConsent((ClientModel)client, offlineClients)).filter(Objects::nonNull);
    }

    private Map<String, Object> toConsent(ClientModel client, Set<ClientModel> offlineClients) {
        UserConsentModel consent = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
        boolean hasOfflineToken = offlineClients.contains(client);
        if (consent == null && !hasOfflineToken) {
            return null;
        }
        UserConsentRepresentation rep = consent == null ? null : ModelToRepresentation.toRepresentation((UserConsentModel)consent);
        HashMap<String, Object> currentRep = new HashMap<String, Object>();
        currentRep.put("clientId", client.getClientId());
        currentRep.put("grantedClientScopes", rep == null ? Collections.emptyList() : rep.getGrantedClientScopes());
        currentRep.put("createdDate", rep == null ? null : rep.getCreatedDate());
        currentRep.put("lastUpdatedDate", rep == null ? null : rep.getLastUpdatedDate());
        LinkedList additionalGrants = new LinkedList();
        if (hasOfflineToken) {
            HashMap<String, String> offlineTokens = new HashMap<String, String>();
            offlineTokens.put("client", client.getId());
            offlineTokens.put("key", "Offline Token");
            additionalGrants.add(offlineTokens);
        }
        currentRep.put("additionalGrants", additionalGrants);
        return currentRep;
    }

    @Path(value="consents/{client}")
    @DELETE
    @NoCache
    public void revokeConsent(@PathParam(value="client") String clientId) {
        this.auth.users().requireManage(this.user);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        boolean revokedConsent = this.session.users().revokeConsentForClient(this.realm, this.user.getId(), client.getId());
        boolean revokedOfflineToken = new UserSessionManager(this.session).revokeOfflineToken(this.user, client);
        if (revokedConsent) {
            AuthenticationManager.backchannelLogoutUserFromClient(this.session, this.realm, this.user, client, (UriInfo)this.session.getContext().getUri(), this.headers);
        }
        if (!revokedConsent && !revokedOfflineToken) {
            throw new NotFoundException("Consent nor offline token not found");
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="logout")
    @POST
    public void logout() {
        this.auth.users().requireManage(this.user);
        this.session.users().setNotBeforeForUser(this.realm, this.user, Time.currentTime());
        this.session.sessions().getUserSessionsStream(this.realm, this.user).collect(Collectors.toList()).forEach(userSession -> AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true));
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    public Response deleteUser() {
        this.auth.users().requireManage(this.user);
        boolean removed = new UserManager(this.session).removeUser(this.realm, this.user);
        if (removed) {
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.noContent().build();
        }
        return ErrorResponse.error("User couldn't be deleted", Response.Status.BAD_REQUEST);
    }

    @Path(value="role-mappings")
    public RoleMapperResource getRoleMappings() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.users().requireMapRoles(this.user);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.users().requireView(this.user);
        RoleMapperResource resource = new RoleMapperResource(this.realm, this.auth, (RoleMapperModel)this.user, this.adminEvent, manageCheck, viewCheck);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="disable-credential-types")
    @PUT
    @Consumes(value={"application/json"})
    public void disableCredentialType(List<String> credentialTypes) {
        this.auth.users().requireManage(this.user);
        if (credentialTypes == null) {
            return;
        }
        for (String type : credentialTypes) {
            this.session.userCredentialManager().disableCredentialType(this.realm, this.user, type);
        }
    }

    @Path(value="reset-password")
    @PUT
    @Consumes(value={"application/json"})
    public void resetPassword(CredentialRepresentation cred) {
        this.auth.users().requireManage(this.user);
        if (cred == null || cred.getValue() == null) {
            throw new BadRequestException("No password provided");
        }
        if (Validation.isBlank(cred.getValue())) {
            throw new BadRequestException("Empty password not allowed");
        }
        try {
            this.session.userCredentialManager().updateCredential(this.realm, this.user, (CredentialInput)UserCredentialModel.password((String)cred.getValue(), (boolean)false));
        }
        catch (IllegalStateException ise) {
            throw new BadRequestException("Resetting to N old passwords is not allowed.");
        }
        catch (ReadOnlyException mre) {
            throw new BadRequestException("Can't reset password as account is read only");
        }
        catch (ModelException e) {
            logger.warn((Object)"Could not update user password.", (Throwable)e);
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(e.getMessage(), MessageFormat.format(messages.getProperty(e.getMessage(), e.getMessage()), e.getParameters()), Response.Status.BAD_REQUEST);
        }
        if (cred.isTemporary() != null && cred.isTemporary().booleanValue()) {
            this.user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        } else {
            this.user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @Path(value="credentials")
    @NoCache
    @Produces(value={"application/json"})
    public Stream<CredentialRepresentation> credentials() {
        this.auth.users().requireManage(this.user);
        return this.session.userCredentialManager().getStoredCredentialsStream(this.realm, this.user).peek(model -> model.setSecretData(null)).map(ModelToRepresentation::toRepresentation);
    }

    @GET
    @Path(value="configured-user-storage-credential-types")
    @NoCache
    @Produces(value={"application/json"})
    public Stream<String> getConfiguredUserStorageCredentialTypes() {
        this.auth.users().requireManage(this.user);
        return this.session.userCredentialManager().getConfiguredUserStorageCredentialTypesStream(this.realm, this.user);
    }

    @Path(value="credentials/{credentialId}")
    @DELETE
    @NoCache
    public void removeCredential(@PathParam(value="credentialId") String credentialId) {
        this.auth.users().requireManage(this.user);
        CredentialModel credential = this.session.userCredentialManager().getStoredCredentialById(this.realm, this.user, credentialId);
        if (credential == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("Credential not found");
            }
            throw new ForbiddenException();
        }
        this.session.userCredentialManager().removeStoredCredential(this.realm, this.user, credentialId);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Path(value="credentials/{credentialId}/userLabel")
    public void setCredentialUserLabel(@PathParam(value="credentialId") String credentialId, String userLabel) {
        this.auth.users().requireManage(this.user);
        CredentialModel credential = this.session.userCredentialManager().getStoredCredentialById(this.realm, this.user, credentialId);
        if (credential == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("Credential not found");
            }
            throw new ForbiddenException();
        }
        this.session.userCredentialManager().updateCredentialLabel(this.realm, this.user, credentialId, userLabel);
    }

    @Path(value="credentials/{credentialId}/moveToFirst")
    @POST
    public void moveCredentialToFirst(@PathParam(value="credentialId") String credentialId) {
        this.moveCredentialAfter(credentialId, null);
    }

    @Path(value="credentials/{credentialId}/moveAfter/{newPreviousCredentialId}")
    @POST
    public void moveCredentialAfter(@PathParam(value="credentialId") String credentialId, @PathParam(value="newPreviousCredentialId") String newPreviousCredentialId) {
        this.auth.users().requireManage(this.user);
        CredentialModel credential = this.session.userCredentialManager().getStoredCredentialById(this.realm, this.user, credentialId);
        if (credential == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("Credential not found");
            }
            throw new ForbiddenException();
        }
        this.session.userCredentialManager().moveCredentialTo(this.realm, this.user, credentialId, newPreviousCredentialId);
    }

    @Deprecated
    @Path(value="reset-password-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response resetPasswordEmail(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        return this.executeActionsEmail(redirectUri, clientId, null, actions);
    }

    @Path(value="execute-actions-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response executeActionsEmail(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId, @QueryParam(value="lifespan") Integer lifespan, List<String> actions) {
        String redirect;
        ClientModel client;
        this.auth.users().requireManage(this.user);
        if (this.user.getEmail() == null) {
            return ErrorResponse.error("User email missing", Response.Status.BAD_REQUEST);
        }
        if (!this.user.isEnabled()) {
            throw new WebApplicationException(ErrorResponse.error("User is disabled", Response.Status.BAD_REQUEST));
        }
        if (redirectUri != null && clientId == null) {
            throw new WebApplicationException(ErrorResponse.error("Client id missing", Response.Status.BAD_REQUEST));
        }
        if (clientId == null) {
            clientId = "account";
        }
        if ((client = this.realm.getClientByClientId(clientId)) == null) {
            logger.debugf("Client %s doesn't exist", (Object)clientId);
            throw new WebApplicationException(ErrorResponse.error("Client doesn't exist", Response.Status.BAD_REQUEST));
        }
        if (!client.isEnabled()) {
            logger.debugf("Client %s is not enabled", (Object)clientId);
            throw new WebApplicationException(ErrorResponse.error("Client is not enabled", Response.Status.BAD_REQUEST));
        }
        if (redirectUri != null && (redirect = RedirectUtils.verifyRedirectUri(this.session, redirectUri, client)) == null) {
            throw new WebApplicationException(ErrorResponse.error("Invalid redirect uri.", Response.Status.BAD_REQUEST));
        }
        if (lifespan == null) {
            lifespan = this.realm.getActionTokenGeneratedByAdminLifespan();
        }
        int expiration = Time.currentTime() + lifespan;
        ExecuteActionsActionToken token = new ExecuteActionsActionToken(this.user.getId(), expiration, actions, redirectUri, clientId);
        try {
            UriBuilder builder = LoginActionsService.actionTokenProcessor((UriInfo)this.session.getContext().getUri());
            builder.queryParam("key", new Object[]{token.serialize(this.session, this.realm, (UriInfo)this.session.getContext().getUri())});
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setAttribute("requiredActions", token.getRequiredActions()).setRealm(this.realm).setUser(this.user).sendExecuteActions(link, TimeUnit.SECONDS.toMinutes(lifespan.intValue()));
            this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.noContent().build();
        }
        catch (EmailException e) {
            ServicesLogger.LOGGER.failedToSendActionsEmail(e);
            return ErrorResponse.error("Failed to send execute actions email", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="send-verify-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response sendVerifyEmail(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.VERIFY_EMAIL.name());
        return this.executeActionsEmail(redirectUri, clientId, null, actions);
    }

    @GET
    @Path(value="groups")
    @NoCache
    @Produces(value={"application/json"})
    public Stream<GroupRepresentation> groupMembership(@QueryParam(value="search") String search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.auth.users().requireView(this.user);
        if (Objects.nonNull(search) && Objects.nonNull(firstResult) && Objects.nonNull(maxResults)) {
            return ModelToRepresentation.searchForGroupByName((UserModel)this.user, (!briefRepresentation ? 1 : 0) != 0, (String)search.trim(), (Integer)firstResult, (Integer)maxResults);
        }
        if (Objects.nonNull(firstResult) && Objects.nonNull(maxResults)) {
            return ModelToRepresentation.toGroupHierarchy((UserModel)this.user, (!briefRepresentation ? 1 : 0) != 0, (Integer)firstResult, (Integer)maxResults);
        }
        return ModelToRepresentation.toGroupHierarchy((UserModel)this.user, (!briefRepresentation ? 1 : 0) != 0);
    }

    @GET
    @NoCache
    @Path(value="groups/count")
    @Produces(value={"application/json"})
    public Map<String, Long> getGroupMembershipCount(@QueryParam(value="search") String search) {
        this.auth.users().requireView(this.user);
        Long results = Objects.nonNull(search) ? Long.valueOf(this.user.getGroupsCountByNameContaining(search)) : Long.valueOf(this.user.getGroupsCount());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", results);
        return map;
    }

    @DELETE
    @Path(value="groups/{groupId}")
    @NoCache
    public void removeMembership(@PathParam(value="groupId") String groupId) {
        this.auth.users().requireManageGroupMembership(this.user);
        GroupModel group = this.session.groups().getGroupById(this.realm, groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.auth.groups().requireManageMembership(group);
        try {
            if (this.user.isMemberOf(group)) {
                this.user.leaveGroup(group);
                this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.GROUP_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true)).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            }
        }
        catch (ModelException me) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(me.getMessage(), MessageFormat.format(messages.getProperty(me.getMessage(), me.getMessage()), me.getParameters()), Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Path(value="groups/{groupId}")
    @NoCache
    public void joinGroup(@PathParam(value="groupId") String groupId) {
        this.auth.users().requireManageGroupMembership(this.user);
        GroupModel group = this.session.groups().getGroupById(this.realm, groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.auth.groups().requireManageMembership(group);
        if (!this.user.isMemberOf(group)) {
            this.user.joinGroup(group);
            this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.GROUP_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true)).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        }
    }

    private UserSessionRepresentation toUserSessionRepresentation(UserSessionModel userSession, String clientUuid) {
        UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientUuid);
        if (clientSession == null) {
            return null;
        }
        rep.setLastAccess((long)clientSession.getTimestamp());
        return rep;
    }
}

