/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo1_5_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.5.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        DefaultAuthenticationFlows.migrateFlows(realm);
        realm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        realm.setBrowserFlow(realm.getFlowByAlias("browser"));
        realm.setRegistrationFlow(realm.getFlowByAlias("registration"));
        realm.setDirectGrantFlow(realm.getFlowByAlias("direct grant"));
        AuthenticationFlowModel resetFlow = realm.getFlowByAlias("reset credentials");
        if (resetFlow == null) {
            DefaultAuthenticationFlows.resetCredentialsFlow(realm);
        } else {
            realm.setResetCredentialsFlow(resetFlow);
        }
        AuthenticationFlowModel clientAuthFlow = realm.getFlowByAlias("clients");
        if (clientAuthFlow == null) {
            DefaultAuthenticationFlows.clientAuthFlow(realm);
        } else {
            realm.setClientAuthenticationFlow(clientAuthFlow);
        }
        realm.getClientsStream().forEach(MigrationUtils::setDefaultClientAuthenticatorType);
    }
}

